# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from .threat_actor_type_id import ThreatActorTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class ThreatActor(UncheckedBaseModel):
    """
    Threat actor is responsible for the observed malicious activity.
    """

    name: str = pydantic.Field()
    """
    The name of the threat actor.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The classification of the threat actor based on their motivations, capabilities, or affiliations. Common types include nation-state actors, cybercriminal groups, hacktivists, or insider threats.
    """

    type_id: typing.Optional[ThreatActorTypeId] = pydantic.Field(default=None)
    """
    The normalized datastore resource type identifier.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
