# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...base.types.file_path import FilePath
from .key_value_object import KeyValueObject
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Image(UncheckedBaseModel):
    """
    The Image object provides a description of a specific Virtual Machine (VM) or Container image.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels associated to the image.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The image name. For example: <code>elixir</code>.
    """

    path: typing.Optional[FilePath] = pydantic.Field(default=None)
    """
    The full path to the image file.
    """

    tag: typing.Optional[str] = pydantic.Field(default=None)
    """
    The image tag. For example: <code>1.11-alpine</code>.
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the image.
    """

    uid: str = pydantic.Field()
    """
    The unique image ID. For example: <code>77af4d6b9913</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
