# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .container import Container
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Request(UncheckedBaseModel):
    """
    The Request Elements object describes characteristics of an API request.
    """

    containers: typing.Optional[typing.List[Container]] = pydantic.Field(default=None)
    """
    When working with containerized applications, the set of containers which write to the standard the output of a particular logging driver. For example, this may be the set of containers involved in handling api requests and responses for a containerized application.
    """

    data: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    The additional data that is associated with the api request.
    """

    flags: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The communication flags that are associated with the api request.
    """

    uid: str = pydantic.Field()
    """
    The unique request identifier.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
