# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .device import Device
import pydantic
from ...base.types.email_address import EmailAddress
from .auth_factor_factor_type_id import AuthFactorFactorTypeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class AuthFactor(UncheckedBaseModel):
    """
    An Authentication Factor object describes a category of methods used for identity verification in an authentication attempt.
    """

    device: typing.Optional[Device] = pydantic.Field(default=None)
    """
    Device used to complete an authentication request.
    """

    email_addr: typing.Optional[EmailAddress] = pydantic.Field(default=None)
    """
    The email address used in an email-based authentication factor.
    """

    factor_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of authentication factor used in an authentication attempt.
    """

    factor_type_id: AuthFactorFactorTypeId = pydantic.Field()
    """
    The normalized identifier for the authentication factor.
    """

    is_hotp: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the authentication factor is an HMAC-based One-time Password (HOTP).
    """

    is_totp: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the authentication factor is a Time-based One-time Password (TOTP).
    """

    phone_number: typing.Optional[str] = pydantic.Field(default=None)
    """
    The phone number used for a telephony-based authentication request.
    """

    provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of provider for an authentication factor.
    """

    security_questions: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The question(s) provided to user for a question-based authentication factor.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
