# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .extension import Extension
from ...base.types.timestamp import Timestamp
import datetime as dt
from .logger import Logger
from .product import Product
from .key_value_object import KeyValueObject
from .transformation_info import TransformationInfo
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Metadata(UncheckedBaseModel):
    """
    The Metadata object describes the metadata associated with the event.
    """

    correlation_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier used to correlate events.
    """

    debug: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    Debug information about non-fatal issues with this OCSF event. Each issue is a line in this string array.
    """

    event_code: typing.Optional[str] = pydantic.Field(default=None)
    """
    The <code>Event ID, Code, or Name</code> that the product uses to primarily identify the event.
    """

    extension: typing.Optional[Extension] = pydantic.Field(default=None)
    """
    The schema extension used to create the event.
    """

    extensions: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    The schema extensions used to create the event.
    """

    is_truncated: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the OCSF event data has been truncated due to size limitations. When <code>true</code>, some event data may have been omitted to fit within system constraints.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of labels attached to the event. For example: <code>["sample", "dev"]</code>
    """

    log_level: typing.Optional[str] = pydantic.Field(default=None)
    """
    The audit level at which an event was generated.
    """

    log_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event log name. For example, syslog file name or Windows logging subsystem: Security.
    """

    log_provider: typing.Optional[str] = pydantic.Field(default=None)
    """
    The logging provider or logging service that logged the event. For example, Microsoft-Windows-Security-Auditing.
    """

    log_version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The event log schema version that specifies the format of the original event. For example syslog version or Cisco Log Schema Version.
    """

    logged_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    <p>The time when the logging system collected and logged the event.</p>This attribute is distinct from the event time in that event time typically contain the time extracted from the original event. Most of the time, these two times will be different.
    """

    logged_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    <p>The time when the logging system collected and logged the event.</p>This attribute is distinct from the event time in that event time typically contain the time extracted from the original event. Most of the time, these two times will be different.
    """

    loggers: typing.Optional[typing.List[Logger]] = pydantic.Field(default=None)
    """
    An array of Logger objects that describe the devices and logging products between the event source and its eventual destination. Note, this attribute can be used when there is a complex end-to-end path of event flow.
    """

    modified_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The time when the event was last modified or enriched.
    """

    modified_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The time when the event was last modified or enriched.
    """

    original_time: typing.Optional[str] = pydantic.Field(default=None)
    """
    The original event time as reported by the event source. For example, the time in the original format from system event log such as Syslog on Unix/Linux and the System event file on Windows. Omit if event is generated instead of collected via logs.
    """

    processed_time: typing.Optional[Timestamp] = pydantic.Field(default=None)
    """
    The event processed time, such as an ETL operation.
    """

    processed_time_dt: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The event processed time, such as an ETL operation.
    """

    product: Product = pydantic.Field()
    """
    The product that reported the event.
    """

    profiles: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    The list of profiles used to create the event. Profiles should be referenced by their <code>name</code> attribute for core profiles, or <code>extension/name</code> for profiles from extensions.
    """

    sequence: typing.Optional[int] = pydantic.Field(default=None)
    """
    Sequence number of the event. The sequence number is a value available in some events, to make the exact ordering of events unambiguous, regardless of the event time precision.
    """

    tags: typing.Optional[typing.List[KeyValueObject]] = pydantic.Field(default=None)
    """
    The list of tags; <code>{key:value}</code> pairs associated to the event.
    """

    tenant_uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique tenant identifier.
    """

    transformation_info_list: typing.Optional[typing.List[TransformationInfo]] = (
        pydantic.Field(default=None)
    )
    """
    An array of transformation info that describes the mappings or transforms applied to the data.
    """

    uid: typing.Optional[str] = pydantic.Field(default=None)
    """
    The logging system-assigned unique identifier of an event instance.
    """

    untruncated_size: typing.Optional[int] = pydantic.Field(default=None)
    """
    The original size of the OCSF event data in kilobytes before any truncation occurred. This field is typically populated when <code>is_truncated</code> is <code>true</code> to indicate the full size of the original event.
    """

    version: str = pydantic.Field()
    """
    The version of the OCSF schema, using Semantic Versioning Specification (<a target='_blank' href='https://semver.org'>SemVer</a>). For example: <code>1.0.0.</code> Event consumers use the version to determine the available event attributes.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
