# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class WebhookEvent(str, enum.Enum):
    TICKET_CREATED = "TicketCreated"
    TICKET_UPDATED = "TicketUpdated"
    TICKET_DELETED = "TicketDeleted"
    TICKET_COMMENT_CREATED = "TicketCommentCreated"
    TICKET_COMMENT_DELETED = "TicketCommentDeleted"
    _UNKNOWN = "__WEBHOOKEVENT_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "WebhookEvent":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        ticket_created: typing.Callable[[], T_Result],
        ticket_updated: typing.Callable[[], T_Result],
        ticket_deleted: typing.Callable[[], T_Result],
        ticket_comment_created: typing.Callable[[], T_Result],
        ticket_comment_deleted: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is WebhookEvent.TICKET_CREATED:
            return ticket_created()
        if self is WebhookEvent.TICKET_UPDATED:
            return ticket_updated()
        if self is WebhookEvent.TICKET_DELETED:
            return ticket_deleted()
        if self is WebhookEvent.TICKET_COMMENT_CREATED:
            return ticket_comment_created()
        if self is WebhookEvent.TICKET_COMMENT_DELETED:
            return ticket_comment_deleted()
        return _unknown_member(self._value_)
