# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from ...organization_base.types.environment import Environment
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CreateAccountRequest(UncheckedBaseModel):
    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique short name for this Account (lowercase [a-z0-9_-], can be used in URLs). Also used for case insensitive duplicate name detection and default sort order. Defaults to AccountId if both name and fullname are not specified.
    """

    fullname: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human friendly display name for this Account, will auto-generate 'name' field (if 'name' is not specified). Defaults to the same value as the 'name' field if not specified.
    """

    environment: typing.Optional[Environment] = pydantic.Field(default=None)
    """
    Environment this account runs in. Defaults to `prod` if not specified.
    """

    labels: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    User defined labels that apply to this account. These values can be used in role bindings to limit the scope of permissions.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
