# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import datetime as dt
import pydantic
from .audit_type import AuditType
from .http_method import HttpMethod
import typing
from ...member_base.types.member_id import MemberId
from ...account_base.types.account_id import AccountId
from ...integration_base.types.integration_id import IntegrationId
from ...bridges.types.bridge_group_id import BridgeGroupId
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Audit(UncheckedBaseModel):
    environment: str
    created_at: dt.datetime = pydantic.Field()
    """
    Time when the API request occurred.
    """

    remote_addr: str
    user_agent: str
    audit_type: AuditType
    method: HttpMethod
    path: str
    code: str
    body: typing.Optional[typing.Optional[typing.Any]] = None
    response: typing.Optional[str] = None
    status: typing.Optional[str] = None
    member_id: typing.Optional[MemberId] = None
    account_id: typing.Optional[AccountId] = None
    integration_id: typing.Optional[IntegrationId] = None
    bridge_group_id: typing.Optional[BridgeGroupId] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
