# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .auth_code import AuthCode
import pydantic
import typing
from ...token_base.types.token_id import TokenId
from ...token_base.types.token_pair import TokenPair
from ...organization_base.types.organization import Organization
from ...member_base.types.member import Member
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class LogonResponseResult(UncheckedBaseModel):
    auth_code: AuthCode = pydantic.Field()
    """
    Authentication result
    """

    auth_msg: typing.Optional[str] = pydantic.Field(default=None)
    """
    Authentication failure message
    """

    refresh_token_id: TokenId
    token: TokenPair
    organization: Organization
    member: Member

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
