# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BridgeLocalConfig(UncheckedBaseModel):
    version: str = pydantic.Field()
    """
    Version of the Bridge.
    """

    allow_addresses: typing.List[str] = pydantic.Field()
    """
    List of IP addresses that the Bridge is allowed to connect to.
    """

    vault: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    Vault configuration for the Bridge.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
