# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...capabilities_base.types.provider_id import ProviderId
import pydantic
from ...capabilities_base.types.category_id import CategoryId
import typing
from .provider_operations import ProviderOperations
from .provider_release import ProviderRelease
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ProviderCapabilitiesBase(UncheckedBaseModel):
    """
    Base properties for provider capabilities. This type is used both
    directly (when providers are nested in connectors) and extended by
    ProviderCapabilities (which adds the expandable connector field).
    """

    id: ProviderId = pydantic.Field()
    """
    Unique identifier for the Provider.
    """

    name: str = pydantic.Field()
    """
    Name of the Provider.
    """

    fullname: str = pydantic.Field()
    """
    Display name of the Provider.
    """

    vendor: str = pydantic.Field()
    """
    Display name of the Provider vendor.
    """

    description: str = pydantic.Field()
    """
    Description of the Provider.
    """

    connector_id: CategoryId = pydantic.Field()
    """
    Id of the Connector that the Provider implements.
    """

    operations: typing.Optional[typing.List[ProviderOperations]] = pydantic.Field(
        default=None
    )
    """
    Operations that the Provider implements.
    """

    provider_config: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(
        default=None
    )
    """
    Details on the specific configuration options for the Provider.
    """

    release: typing.Optional[ProviderRelease] = pydantic.Field(default=None)
    """
    Provider availability information.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
