# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .parameter_location import ParameterLocation
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ProblematicParameter(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    If the `location` of the parameter is `body`, this value is always a JSON Pointer, otherwise it's the name of the parameter.
    """

    location: ParameterLocation = pydantic.Field()
    """
    The location of the parameter. Possible values are `query`, `header`, `path` or `body`.
    """

    value: typing.Optional[typing.Optional[typing.Any]] = pydantic.Field(default=None)
    """
    The given value of the parameter.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
