# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
import pydantic
from .webhook_item import WebhookItem
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class WebhookConfig(UncheckedBaseModel):
    provider_key: typing.Optional[str] = pydantic.Field(default=None)
    """
    The key used by Synqly to verify incoming webhook payloads sent by the Provider. The format and requirements for this key is Provider specific:
    
    - **ServiceNow**: Webhook payload signing is not currently supported, so the integrity of incoming ServiceNow payloads cannot be verified.
    - **Jira**: Synqly does _not_ automatically configure Jira webhooks. A user with administrator privileges must configure the webhook, including the signing key. If this key is not specified, Synqly will _not_ validate incoming webhooks from Jira. It is strongly recommended that a key is specified and configured with Jira to ensure the integrity of incoming payloads.
    """

    items: typing.List[WebhookItem] = pydantic.Field()
    """
    List of webhooks for an integration. If the provider supports webhooks, they will be sent to the servers provided in this list.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
