# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...common.types.resource_id import ResourceId
import pydantic
import typing
from ...common.types.action_id import ActionId
from .mapping_data_type import MappingDataType
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AdditionalMapping(UncheckedBaseModel):
    resource: ResourceId = pydantic.Field()
    """
    The resources that this mapping applies to.
    """

    actions: typing.List[ActionId] = pydantic.Field()
    """
    The actions that this mapping applies to. At least one action must be specified.
    """

    source: str = pydantic.Field()
    """
    The dot-separated path to the field in the source data coming from the provider. Use `\.` to escape literal dots in the field name.
    """

    destination: str = pydantic.Field()
    """
    The dot-separated path to where the data should reside in the custom fields object when data is returned from the provider.
    """

    literal: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, the value in 'source' is treated as a literal value rather than a mapping. This allows adding static values to custom fields. Default: false
    """

    data_type: MappingDataType = pydantic.Field()
    """
    The data type of the field. This ensures the data is processed to the correct type when mapping. Fields set to 'any' will not get validated
    or processed. Other types are cast depending as defined by each provider. For example, a field with 'datetime' is parsed based on the date
    format used by the provider, and normalized to a unix timestamp with millisecond precision.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
