# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .operation_incremental_pull_mode import OperationIncrementalPullMode
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OperationIncrementalPullConfig(UncheckedBaseModel):
    """
    Controls how data is fetched from the source API on each execution.
    """

    mode: OperationIncrementalPullMode = pydantic.Field()
    """
    Fetch strategy: incremental (only changed data) or full_snapshot (all data every time).
    """

    time_filter_field: typing.Optional[str] = pydantic.Field(default=None)
    """
    Custom field to use for time-based filtering in incremental mode.
    Overrides the operation's default time filter field.
    Examples: "modified_time" or "finding.last_seen_time".
    The filter will use this field with "[gt]" (greater than) operator.
    First run will use `initial_backfill_start_time` as the filter value, and
    subsequent runs use the last execution time.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
