# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...organization_webhook_base.types.webhook_filter import WebhookFilter
import pydantic
import typing
from ...accounts.types.account import Account
from ...integrations.types.integration import Integration
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class OrganizationWebhookPayload(UncheckedBaseModel):
    """
    Response payload for webhook events. This payload is sent to the webhook URL when an event occurs.
    """

    event: WebhookFilter = pydantic.Field()
    """
    The event that triggered the webhook
    """

    account: typing.Optional[Account] = pydantic.Field(default=None)
    """
    The account that the event occurred in
    """

    integration: typing.Optional[Integration] = pydantic.Field(default=None)
    """
    The integration that the event occurred in
    """

    nonce: str = pydantic.Field()
    """
    A unique identifier for this webhook event
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
