# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .nozomi_vantage_credential import NozomiVantageCredential
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class AssetsNozomiVantage(UncheckedBaseModel):
    """
    Configuration for Nozomi Vantage.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/nozomi-vantage-setup)
    """

    credential: NozomiVantageCredential = pydantic.Field()
    """
    Credentials used to authenticate with Nozomi Vantage.
    """

    url: str = pydantic.Field()
    """
    Base URL for the Nozomi Vantage API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
