# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .custom_credential import CustomCredential
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CustomEndpoint(UncheckedBaseModel):
    """
    Defines URL and Credential to use for the endpoint
    """

    credential: CustomCredential = pydantic.Field()
    """
    The credential to use for the custom endpoint. Review the custom provider definition for the custom_id you supplied for the credential type that must be defined.
    """

    skip_tls_verify: typing.Optional[bool] = pydantic.Field(default=None)
    """
    When true, skips verification of the TLS certificate.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Custom URL for the provider. If not provided, the default endpoint URL defined in the provider definition for the provided custom_id will be used instead.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
