# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .malwarebytes_credential import MalwarebytesCredential
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class EdrMalwarebytes(UncheckedBaseModel):
    """
    Configuration for ThreatDown Endpoint Detection & Response.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/malwarebytes-setup)
    """

    account_identifier: str = pydantic.Field()
    """
    Account identifier for the ThreatDown EDR tenant.
    """

    credential: MalwarebytesCredential
    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    Base URL for the ThreatDown EDR API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
