# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .google_credential import GoogleCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class IdentityGoogle(UncheckedBaseModel):
    """
    Configuration for Google Workspace.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/google-workspace-setup)
    """

    client_email: str = pydantic.Field()
    """
    Client email associated with the service account key.
    """

    credential: GoogleCredential
    delegate: str = pydantic.Field()
    """
    Email address of the user that the service account is impersonating for domain-wide delegation. For more information, see [this Google support article](https://support.google.com/a/answer/162106).
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
