# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .ping_one_auth_url import PingOneAuthUrl
import pydantic
from .ping_one_credential import PingOneCredential
from .ping_one_apiurl import PingOneApiurl
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class IdentityPingOne(UncheckedBaseModel):
    """
    Configuration for PingOne Cloud Platform.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/ping-identity-setup)
    """

    auth_url: PingOneAuthUrl = pydantic.Field()
    """
    Base URL for making authentication requests to PingOne.
    """

    client_id: str = pydantic.Field()
    """
    Client ID for the application set up as a worker.
    """

    credential: PingOneCredential
    organization_id: str = pydantic.Field()
    """
    The organization ID that the client app is a part of.
    """

    url: PingOneApiurl = pydantic.Field()
    """
    Base URL for the PingOne API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
