# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .google_service_account_credential import GoogleServiceAccountCredential
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class SiemGoogleSecurityOperations(UncheckedBaseModel):
    """
    Configuration for Google Security Operations (formerly Google Chronicle) as a SIEM Provider.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/google-security-operations-siem-setup)
    """

    credential: GoogleServiceAccountCredential = pydantic.Field()
    """
    Credentials used for accessing the Google SecOps instance.
    """

    customer_id: str = pydantic.Field()
    """
    The customer ID of the Google SecOps instance.
    """

    project_id: str = pydantic.Field()
    """
    The project ID of the Google SecOps instance.
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The region of the Google SecOps instance. Usually `us` or `eu`.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The base URL for the Google SecOps API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
