# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .crowdstrike_hec_credential import CrowdstrikeHecCredential
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class SinkCrowdstrikeHec(UncheckedBaseModel):
    """
    Configuration for CrowdStrike Falcon® Next-Gen SIEM (HEC).

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/crowdstrike-sink-setup)
    """

    credential: CrowdstrikeHecCredential
    url: str = pydantic.Field()
    """
    HTTPS URL for the CrowdStrike HTTP Event Collector (HEC) API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
