# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import pydantic
from .gcs_json_credential import GcsJsonCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class SinkGcs(UncheckedBaseModel):
    """
    Configuration for Google Cloud Storage as a Sink provider. Events are written directly to a GCS bucket in compressed JSON format.
    """

    bucket: str = pydantic.Field()
    """
    Name of the GCS bucket
    """

    credential: GcsJsonCredential = pydantic.Field()
    """
    Google Cloud Service Account JSON key with write access to the configured GCS bucket
    """

    path: str = pydantic.Field()
    """
    Files will be written under this path.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
