# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations
from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import pydantic
from ...credentials.types.o_auth_client_credential_id import OAuthClientCredentialId
from ...credentials.types.secret_credential_id import SecretCredentialId
import typing_extensions
from ...core.unchecked_base_model import UnionMetadata


class TeamsCredential_OAuthClient(UncheckedBaseModel):
    type: typing.Literal["o_auth_client"] = "o_auth_client"
    token_url: typing.Optional[str] = None
    client_id: str
    client_secret: str
    extra: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class TeamsCredential_OAuthClientId(UncheckedBaseModel):
    value: OAuthClientCredentialId
    type: typing.Literal["o_auth_client_id"] = "o_auth_client_id"

    class Config:
        smart_union = True


class TeamsCredential_WebhookUrl(UncheckedBaseModel):
    type: typing.Literal["webhook_url"] = "webhook_url"
    secret: str

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow


class TeamsCredential_WebhookUrlId(UncheckedBaseModel):
    value: SecretCredentialId
    type: typing.Literal["webhook_url_id"] = "webhook_url_id"

    class Config:
        smart_union = True


TeamsCredential = typing_extensions.Annotated[
    typing.Union[
        TeamsCredential_OAuthClient,
        TeamsCredential_OAuthClientId,
        TeamsCredential_WebhookUrl,
        TeamsCredential_WebhookUrlId,
    ],
    UnionMetadata(discriminant="type"),
]
