# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .autotask_api_integration_code_credential import (
    AutotaskApiIntegrationCodeCredential,
)
import typing
import pydantic
from .autotask_secret_credential import AutotaskSecretCredential
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TicketingAutotask(UncheckedBaseModel):
    """
    Configuration for Autotask Operations Cloud.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/autotask-ticketing-setup)
    """

    api_integration_code_credential: AutotaskApiIntegrationCodeCredential
    default_issue_type: typing.Optional[int] = pydantic.Field(default=None)
    """
    Default Issue Type (Ticket Category) for the integration. If provided, the issue_type field becomes optional in ticket creation requests. In Autotask, this corresponds to the Ticket Category ID.
    """

    default_project: typing.Optional[int] = pydantic.Field(default=None)
    """
    Default Project (Company ID) for the integration. If provided, the project field becomes optional in ticket creation requests. In Autotask, this corresponds to the Company ID associated with tickets.
    """

    secret_credential: AutotaskSecretCredential
    user_name: str = pydantic.Field()
    """
    User name of the API User created to authenticate with the Autotask API.
    """

    zone_path: str = pydantic.Field()
    """
    Zone for the Autotask API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
