# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .jira_credential import JiraCredential
import typing
from .custom_field_mapping import CustomFieldMapping
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TicketingJiraServiceManagement(UncheckedBaseModel):
    """
    Configuration for Jira Service Management.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/jira-service-management-ticketing-setup)
    """

    credential: JiraCredential
    custom_field_mappings: typing.Optional[typing.List[CustomFieldMapping]] = (
        pydantic.Field(default=None)
    )
    """
    Custom field mappings for this provider.
    """

    default_issue_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Default issue type when creating tickets.
    """

    default_project: typing.Optional[str] = pydantic.Field(default=None)
    """
    Default project when listing, creating, or editing tickets.
    """

    url: str = pydantic.Field()
    """
    Base URL for the Jira Service Management API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
