# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
import typing
from .custom_field_mapping import CustomFieldMapping
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TicketingMock(UncheckedBaseModel):
    """
    Configuration for the Synqly mock in-memory ticketing Provider. This provider is for testing purposes only. It retains tickets for a limited time and does not persist them for long-term usage.
    """

    custom_field_mappings: typing.Optional[typing.List[CustomFieldMapping]] = (
        pydantic.Field(default=None)
    )
    """
    Custom field mappings for this provider.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional name of the mock provider. This value is unused.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
