# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .service_now_credential import ServiceNowCredential
import typing
from .custom_field_mapping import CustomFieldMapping
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TicketingServiceNowSir(UncheckedBaseModel):
    """
    Configuration for ServiceNow Security Incident Response (SIR).

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/servicenow-ticketing-setup)
    """

    credential: ServiceNowCredential
    custom_field_mappings: typing.Optional[typing.List[CustomFieldMapping]] = (
        pydantic.Field(default=None)
    )
    """
    Custom field mappings for this provider.
    """

    default_creator: typing.Optional[str] = pydantic.Field(default=None)
    """
    Default Creator (email) for the integration. If provided, the creator field becomes optional in ticket creation requests.
    """

    default_issue_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Default Issue Type for the integration. If provided, the issue_type field becomes optional in ticket creation requests.
    """

    default_project: typing.Optional[str] = pydantic.Field(default=None)
    """
    Default Project for the integration. This maps to the custom table for tickets. This table should be derived from Security Incident table. Defaults to the security incident table if not specified.
    """

    url: str = pydantic.Field()
    """
    Base URL for the ServiceNow API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
