# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .nucleus_credential import NucleusCredential
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class VulnerabilitiesNucleus(UncheckedBaseModel):
    """
    Configuration for Nucleus Vulnerability Management.

    [Configuration guide](https://docs.synqly.com/guides/provider-configuration/nucleus-vulns-setup)
    """

    credential: NucleusCredential
    project_id: str = pydantic.Field()
    """
    Numeric identifier for a Nucleus project.
    """

    url: str = pydantic.Field()
    """
    Base URL for the Nucleus API.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
