# This file was auto-generated by Fern from our API Definition.

from ...common.types.base import Base
from ...role_base.types.role_id import RoleId
import pydantic
import typing
from ...role_base.types.resources import Resources
from ...permissionset_base.types.permissions import Permissions
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class RoleDefinition(Base):
    id: RoleId
    fullname: str = pydantic.Field()
    """
    Full name of role
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Description of the resources included in the role and permissions granted on those resources. Includes details of when to use this role along with the intended personas.
    """

    resources: typing.Optional[Resources] = pydantic.Field(default=None)
    """
    Selects the resources the permission set applies to.
    """

    permission_set: Permissions = pydantic.Field()
    """
    Permission set for this role.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
