# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from ...account_base.types.account_id import AccountId
import pydantic
import typing
from ...operation_id_generated.types.operation_id import OperationId
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class McpIntegrationUsageScopeOptions(UncheckedBaseModel):
    account_id: AccountId = pydantic.Field()
    """
    Restrict integration usage to this account. By default, the MCP server
    will have access to all integrations within this account; this may be
    restricted to a specific set of tools using the
    `restrict_to_connector_operations` property.
    """

    restrict_to_connector_operations: typing.Optional[typing.List[OperationId]] = (
        pydantic.Field(default=None)
    )
    """
    Optionally restrict access to the tools associated with the specified
    connector operations. If not specified, the MCP server will advertise
    all tools for this scope.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
