# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAccountsResult',
    'AwaitableGetAccountsResult',
    'get_accounts',
    'get_accounts_output',
]

@pulumi.output_type
class GetAccountsResult:
    """
    A collection of values returned by getAccounts.
    """
    def __init__(__self__, account_details=None, account_ids=None, describe=None, id=None):
        if account_details and not isinstance(account_details, list):
            raise TypeError("Expected argument 'account_details' to be a list")
        pulumi.set(__self__, "account_details", account_details)
        if account_ids and not isinstance(account_ids, list):
            raise TypeError("Expected argument 'account_ids' to be a list")
        pulumi.set(__self__, "account_ids", account_ids)
        if describe and not isinstance(describe, bool):
            raise TypeError("Expected argument 'describe' to be a bool")
        pulumi.set(__self__, "describe", describe)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @_builtins.property
    @pulumi.getter(name="accountDetails")
    def account_details(self) -> Sequence['outputs.GetAccountsAccountDetailResult']:
        """
        List of account details.
        """
        return pulumi.get(self, "account_details")

    @_builtins.property
    @pulumi.getter(name="accountIds")
    def account_ids(self) -> Sequence[_builtins.str]:
        """
        List of account ids.
        """
        return pulumi.get(self, "account_ids")

    @_builtins.property
    @pulumi.getter
    def describe(self) -> Optional[_builtins.bool]:
        """
        Flag to include account details while listing accounts. Defaults to `false`.
        """
        return pulumi.get(self, "describe")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetAccountsResult(GetAccountsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountsResult(
            account_details=self.account_details,
            account_ids=self.account_ids,
            describe=self.describe,
            id=self.id)


def get_accounts(account_details: Optional[Sequence[Union['GetAccountsAccountDetailArgs', 'GetAccountsAccountDetailArgsDict']]] = None,
                 account_ids: Optional[Sequence[_builtins.str]] = None,
                 describe: Optional[_builtins.bool] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountsResult:
    """
    Data source get a list of Accounts.

    ## Admin Permission Type

    * `Rulestack` (for `scope="Local"`)
    * `Global Rulestack` (for `scope="Global"`)


    :param Sequence[Union['GetAccountsAccountDetailArgs', 'GetAccountsAccountDetailArgsDict']] account_details: List of account details.
    :param Sequence[_builtins.str] account_ids: List of account ids.
    :param _builtins.bool describe: Flag to include account details while listing accounts. Defaults to `false`.
    """
    __args__ = dict()
    __args__['accountDetails'] = account_details
    __args__['accountIds'] = account_ids
    __args__['describe'] = describe
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudngfwaws:index/getAccounts:getAccounts', __args__, opts=opts, typ=GetAccountsResult).value

    return AwaitableGetAccountsResult(
        account_details=pulumi.get(__ret__, 'account_details'),
        account_ids=pulumi.get(__ret__, 'account_ids'),
        describe=pulumi.get(__ret__, 'describe'),
        id=pulumi.get(__ret__, 'id'))
def get_accounts_output(account_details: Optional[pulumi.Input[Optional[Sequence[Union['GetAccountsAccountDetailArgs', 'GetAccountsAccountDetailArgsDict']]]]] = None,
                        account_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                        describe: Optional[pulumi.Input[Optional[_builtins.bool]]] = None,
                        opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountsResult]:
    """
    Data source get a list of Accounts.

    ## Admin Permission Type

    * `Rulestack` (for `scope="Local"`)
    * `Global Rulestack` (for `scope="Global"`)


    :param Sequence[Union['GetAccountsAccountDetailArgs', 'GetAccountsAccountDetailArgsDict']] account_details: List of account details.
    :param Sequence[_builtins.str] account_ids: List of account ids.
    :param _builtins.bool describe: Flag to include account details while listing accounts. Defaults to `false`.
    """
    __args__ = dict()
    __args__['accountDetails'] = account_details
    __args__['accountIds'] = account_ids
    __args__['describe'] = describe
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudngfwaws:index/getAccounts:getAccounts', __args__, opts=opts, typ=GetAccountsResult)
    return __ret__.apply(lambda __response__: GetAccountsResult(
        account_details=pulumi.get(__response__, 'account_details'),
        account_ids=pulumi.get(__response__, 'account_ids'),
        describe=pulumi.get(__response__, 'describe'),
        id=pulumi.get(__response__, 'id')))
