# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetNgfwsResult',
    'AwaitableGetNgfwsResult',
    'get_ngfws',
    'get_ngfws_output',
]

@pulumi.output_type
class GetNgfwsResult:
    """
    A collection of values returned by getNgfws.
    """
    def __init__(__self__, id=None, instances=None, region=None, rulestack=None, vpc_ids=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if rulestack and not isinstance(rulestack, str):
            raise TypeError("Expected argument 'rulestack' to be a str")
        pulumi.set(__self__, "rulestack", rulestack)
        if vpc_ids and not isinstance(vpc_ids, list):
            raise TypeError("Expected argument 'vpc_ids' to be a list")
        pulumi.set(__self__, "vpc_ids", vpc_ids)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.GetNgfwsInstanceResult']:
        """
        List of NGFWs.
        """
        return pulumi.get(self, "instances")

    @_builtins.property
    @pulumi.getter
    def region(self) -> Optional[_builtins.str]:
        """
        The region to filter on.
        """
        return pulumi.get(self, "region")

    @_builtins.property
    @pulumi.getter
    def rulestack(self) -> Optional[_builtins.str]:
        """
        The rulestack to filter on.
        """
        return pulumi.get(self, "rulestack")

    @_builtins.property
    @pulumi.getter(name="vpcIds")
    def vpc_ids(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of vpc ids to filter on.
        """
        return pulumi.get(self, "vpc_ids")


class AwaitableGetNgfwsResult(GetNgfwsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNgfwsResult(
            id=self.id,
            instances=self.instances,
            region=self.region,
            rulestack=self.rulestack,
            vpc_ids=self.vpc_ids)


def get_ngfws(region: Optional[_builtins.str] = None,
              rulestack: Optional[_builtins.str] = None,
              vpc_ids: Optional[Sequence[_builtins.str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNgfwsResult:
    """
    Data source get a list of NGFWs.

    ## Admin Permission Type

    * `Firewall`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudngfwaws as cloudngfwaws

    example = cloudngfwaws.get_ngfws()
    ```


    :param _builtins.str region: The region to filter on.
    :param _builtins.str rulestack: The rulestack to filter on.
    :param Sequence[_builtins.str] vpc_ids: List of vpc ids to filter on.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['rulestack'] = rulestack
    __args__['vpcIds'] = vpc_ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('cloudngfwaws:index/getNgfws:getNgfws', __args__, opts=opts, typ=GetNgfwsResult).value

    return AwaitableGetNgfwsResult(
        id=pulumi.get(__ret__, 'id'),
        instances=pulumi.get(__ret__, 'instances'),
        region=pulumi.get(__ret__, 'region'),
        rulestack=pulumi.get(__ret__, 'rulestack'),
        vpc_ids=pulumi.get(__ret__, 'vpc_ids'))
def get_ngfws_output(region: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     rulestack: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                     vpc_ids: Optional[pulumi.Input[Optional[Sequence[_builtins.str]]]] = None,
                     opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetNgfwsResult]:
    """
    Data source get a list of NGFWs.

    ## Admin Permission Type

    * `Firewall`

    ## Example Usage

    ```python
    import pulumi
    import pulumi_cloudngfwaws as cloudngfwaws

    example = cloudngfwaws.get_ngfws()
    ```


    :param _builtins.str region: The region to filter on.
    :param _builtins.str rulestack: The rulestack to filter on.
    :param Sequence[_builtins.str] vpc_ids: List of vpc ids to filter on.
    """
    __args__ = dict()
    __args__['region'] = region
    __args__['rulestack'] = rulestack
    __args__['vpcIds'] = vpc_ids
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('cloudngfwaws:index/getNgfws:getNgfws', __args__, opts=opts, typ=GetNgfwsResult)
    return __ret__.apply(lambda __response__: GetNgfwsResult(
        id=pulumi.get(__response__, 'id'),
        instances=pulumi.get(__response__, 'instances'),
        region=pulumi.get(__response__, 'region'),
        rulestack=pulumi.get(__response__, 'rulestack'),
        vpc_ids=pulumi.get(__response__, 'vpc_ids')))
