# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'NgfwEgressNat',
    'NgfwEgressNatSetting',
    'NgfwEndpoint',
    'NgfwEndpointPrefix',
    'NgfwEndpointPrefixPrivatePrefix',
    'NgfwLogProfileLogConfig',
    'NgfwLogProfileLogDestination',
    'NgfwPrivateAccess',
    'NgfwStatus',
    'NgfwSubnetMapping',
    'NgfwUserId',
    'NgfwUserIdCustomIncludeExcludeNetwork',
    'RulestackProfileConfig',
    'SecurityRuleCategory',
    'SecurityRuleDestination',
    'SecurityRuleSource',
    'GetAccountsAccountDetailResult',
    'GetNgfwEgressNatResult',
    'GetNgfwEgressNatSettingResult',
    'GetNgfwEndpointResult',
    'GetNgfwEndpointPrefixResult',
    'GetNgfwEndpointPrefixPrivatePrefixResult',
    'GetNgfwLogProfileLogConfigResult',
    'GetNgfwLogProfileLogDestinationResult',
    'GetNgfwPrivateAccessResult',
    'GetNgfwStatusResult',
    'GetNgfwSubnetMappingResult',
    'GetNgfwUserIdResult',
    'GetNgfwUserIdCustomIncludeExcludeNetworkResult',
    'GetNgfwsInstanceResult',
    'GetRulestackProfileConfigResult',
    'GetSecurityRuleCategoryResult',
    'GetSecurityRuleDestinationResult',
    'GetSecurityRuleSourceResult',
]

@pulumi.output_type
class NgfwEgressNat(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 settings: Optional[Sequence['outputs.NgfwEgressNatSetting']] = None):
        """
        :param _builtins.bool enabled: Enable egress NAT
        """
        pulumi.set(__self__, "enabled", enabled)
        if settings is not None:
            pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable egress NAT
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Optional[Sequence['outputs.NgfwEgressNatSetting']]:
        return pulumi.get(self, "settings")


@pulumi.output_type
class NgfwEgressNatSetting(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipPoolType":
            suggest = "ip_pool_type"
        elif key == "ipamPoolId":
            suggest = "ipam_pool_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwEgressNatSetting. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwEgressNatSetting.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwEgressNatSetting.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_pool_type: Optional[_builtins.str] = None,
                 ipam_pool_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str ip_pool_type: Set ip pool type from the following options. Valid values are `AWSService` or `BYOIP`.
        :param _builtins.str ipam_pool_id: The IP pool ID
        """
        if ip_pool_type is not None:
            pulumi.set(__self__, "ip_pool_type", ip_pool_type)
        if ipam_pool_id is not None:
            pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)

    @_builtins.property
    @pulumi.getter(name="ipPoolType")
    def ip_pool_type(self) -> Optional[_builtins.str]:
        """
        Set ip pool type from the following options. Valid values are `AWSService` or `BYOIP`.
        """
        return pulumi.get(self, "ip_pool_type")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> Optional[_builtins.str]:
        """
        The IP pool ID
        """
        return pulumi.get(self, "ipam_pool_id")


@pulumi.output_type
class NgfwEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountId":
            suggest = "account_id"
        elif key == "egressNatEnabled":
            suggest = "egress_nat_enabled"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "rejectedReason":
            suggest = "rejected_reason"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "vpcId":
            suggest = "vpc_id"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mode: _builtins.str,
                 account_id: Optional[_builtins.str] = None,
                 egress_nat_enabled: Optional[_builtins.bool] = None,
                 endpoint_id: Optional[_builtins.str] = None,
                 prefixes: Optional[Sequence['outputs.NgfwEndpointPrefix']] = None,
                 rejected_reason: Optional[_builtins.str] = None,
                 status: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None,
                 vpc_id: Optional[_builtins.str] = None,
                 zone_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str mode: The endpoint mode. Valid values are `ServiceManaged` or `CustomerManaged`.
        :param _builtins.str account_id: The account id.
        :param _builtins.bool egress_nat_enabled: Enable egress NAT
        :param _builtins.str endpoint_id: Endpoint ID of the security zone
        :param _builtins.str rejected_reason: The rejected reason.
        :param _builtins.str status: The attachment status.
        :param _builtins.str subnet_id: The subnet id.
        :param _builtins.str vpc_id: The vpc id.
        :param _builtins.str zone_id: The AZ id.
        """
        pulumi.set(__self__, "mode", mode)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if egress_nat_enabled is not None:
            pulumi.set(__self__, "egress_nat_enabled", egress_nat_enabled)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if prefixes is not None:
            pulumi.set(__self__, "prefixes", prefixes)
        if rejected_reason is not None:
            pulumi.set(__self__, "rejected_reason", rejected_reason)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The endpoint mode. Valid values are `ServiceManaged` or `CustomerManaged`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        The account id.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="egressNatEnabled")
    def egress_nat_enabled(self) -> Optional[_builtins.bool]:
        """
        Enable egress NAT
        """
        return pulumi.get(self, "egress_nat_enabled")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[_builtins.str]:
        """
        Endpoint ID of the security zone
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def prefixes(self) -> Optional[Sequence['outputs.NgfwEndpointPrefix']]:
        return pulumi.get(self, "prefixes")

    @_builtins.property
    @pulumi.getter(name="rejectedReason")
    def rejected_reason(self) -> Optional[_builtins.str]:
        """
        The rejected reason.
        """
        return pulumi.get(self, "rejected_reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> Optional[_builtins.str]:
        """
        The attachment status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[_builtins.str]:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[_builtins.str]:
        """
        The AZ id.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class NgfwEndpointPrefix(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privatePrefixes":
            suggest = "private_prefixes"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwEndpointPrefix. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwEndpointPrefix.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwEndpointPrefix.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 private_prefixes: Optional[Sequence['outputs.NgfwEndpointPrefixPrivatePrefix']] = None):
        if private_prefixes is not None:
            pulumi.set(__self__, "private_prefixes", private_prefixes)

    @_builtins.property
    @pulumi.getter(name="privatePrefixes")
    def private_prefixes(self) -> Optional[Sequence['outputs.NgfwEndpointPrefixPrivatePrefix']]:
        return pulumi.get(self, "private_prefixes")


@pulumi.output_type
class NgfwEndpointPrefixPrivatePrefix(dict):
    def __init__(__self__, *,
                 cidrs: Optional[Sequence[_builtins.str]] = None):
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[_builtins.str]]:
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class NgfwLogProfileLogConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "logDestination":
            suggest = "log_destination"
        elif key == "logDestinationType":
            suggest = "log_destination_type"
        elif key == "logTypes":
            suggest = "log_types"
        elif key == "accountId":
            suggest = "account_id"
        elif key == "roleType":
            suggest = "role_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwLogProfileLogConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwLogProfileLogConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwLogProfileLogConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 log_destination: _builtins.str,
                 log_destination_type: _builtins.str,
                 log_types: Sequence[_builtins.str],
                 account_id: Optional[_builtins.str] = None,
                 role_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str log_destination: The log destination details.
        :param _builtins.str log_destination_type: The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        :param Sequence[_builtins.str] log_types: The list of different log types that are wanted
        :param _builtins.str account_id: Type of Role for log configuration
        :param _builtins.str role_type: Type of Role for log configuration
        """
        pulumi.set(__self__, "log_destination", log_destination)
        pulumi.set(__self__, "log_destination_type", log_destination_type)
        pulumi.set(__self__, "log_types", log_types)
        if account_id is not None:
            pulumi.set(__self__, "account_id", account_id)
        if role_type is not None:
            pulumi.set(__self__, "role_type", role_type)

    @_builtins.property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> _builtins.str:
        """
        The log destination details.
        """
        return pulumi.get(self, "log_destination")

    @_builtins.property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> _builtins.str:
        """
        The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        """
        return pulumi.get(self, "log_destination_type")

    @_builtins.property
    @pulumi.getter(name="logTypes")
    def log_types(self) -> Sequence[_builtins.str]:
        """
        The list of different log types that are wanted
        """
        return pulumi.get(self, "log_types")

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> Optional[_builtins.str]:
        """
        Type of Role for log configuration
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> Optional[_builtins.str]:
        """
        Type of Role for log configuration
        """
        return pulumi.get(self, "role_type")


@pulumi.output_type
class NgfwLogProfileLogDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationType":
            suggest = "destination_type"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwLogProfileLogDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwLogProfileLogDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwLogProfileLogDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 destination: Optional[_builtins.str] = None,
                 destination_type: Optional[_builtins.str] = None,
                 log_type: Optional[_builtins.str] = None):
        """
        :param _builtins.str destination: The log destination details.
        :param _builtins.str destination_type: The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        :param _builtins.str log_type: The type of logs. Valid values are `TRAFFIC`, `THREAT`, or `DECRYPTION`.
        """
        if destination is not None:
            pulumi.set(__self__, "destination", destination)
        if destination_type is not None:
            pulumi.set(__self__, "destination_type", destination_type)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> Optional[_builtins.str]:
        """
        The log destination details.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> Optional[_builtins.str]:
        """
        The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[_builtins.str]:
        """
        The type of logs. Valid values are `TRAFFIC`, `THREAT`, or `DECRYPTION`.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class NgfwPrivateAccess(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "resourceId":
            suggest = "resource_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwPrivateAccess. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwPrivateAccess.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwPrivateAccess.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str resource_id: AWS ResourceID
        :param _builtins.str type: Type of Private Access
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        AWS ResourceID
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of Private Access
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class NgfwStatus(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deviceRulestackCommitStatus":
            suggest = "device_rulestack_commit_status"
        elif key == "failureReason":
            suggest = "failure_reason"
        elif key == "firewallStatus":
            suggest = "firewall_status"
        elif key == "rulestackStatus":
            suggest = "rulestack_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwStatus. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwStatus.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwStatus.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 device_rulestack_commit_status: Optional[_builtins.str] = None,
                 failure_reason: Optional[_builtins.str] = None,
                 firewall_status: Optional[_builtins.str] = None,
                 rulestack_status: Optional[_builtins.str] = None):
        """
        :param _builtins.str device_rulestack_commit_status: The device rulestack commit status.
        :param _builtins.str failure_reason: The firewall failure reason.
        :param _builtins.str firewall_status: The firewall status.
        :param _builtins.str rulestack_status: The rulestack status.
        """
        if device_rulestack_commit_status is not None:
            pulumi.set(__self__, "device_rulestack_commit_status", device_rulestack_commit_status)
        if failure_reason is not None:
            pulumi.set(__self__, "failure_reason", failure_reason)
        if firewall_status is not None:
            pulumi.set(__self__, "firewall_status", firewall_status)
        if rulestack_status is not None:
            pulumi.set(__self__, "rulestack_status", rulestack_status)

    @_builtins.property
    @pulumi.getter(name="deviceRulestackCommitStatus")
    def device_rulestack_commit_status(self) -> Optional[_builtins.str]:
        """
        The device rulestack commit status.
        """
        return pulumi.get(self, "device_rulestack_commit_status")

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> Optional[_builtins.str]:
        """
        The firewall failure reason.
        """
        return pulumi.get(self, "failure_reason")

    @_builtins.property
    @pulumi.getter(name="firewallStatus")
    def firewall_status(self) -> Optional[_builtins.str]:
        """
        The firewall status.
        """
        return pulumi.get(self, "firewall_status")

    @_builtins.property
    @pulumi.getter(name="rulestackStatus")
    def rulestack_status(self) -> Optional[_builtins.str]:
        """
        The rulestack status.
        """
        return pulumi.get(self, "rulestack_status")


@pulumi.output_type
class NgfwSubnetMapping(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityZone":
            suggest = "availability_zone"
        elif key == "availabilityZoneId":
            suggest = "availability_zone_id"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwSubnetMapping. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwSubnetMapping.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwSubnetMapping.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_zone: Optional[_builtins.str] = None,
                 availability_zone_id: Optional[_builtins.str] = None,
                 subnet_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str availability_zone: The availability zone, for when the endpoint mode is customer managed.
        :param _builtins.str availability_zone_id: The availability zone ID, for when the endpoint mode is customer managed.
        :param _builtins.str subnet_id: The subnet id, for when the endpoint mode is service managed.
        """
        if availability_zone is not None:
            pulumi.set(__self__, "availability_zone", availability_zone)
        if availability_zone_id is not None:
            pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> Optional[_builtins.str]:
        """
        The availability zone, for when the endpoint mode is customer managed.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> Optional[_builtins.str]:
        """
        The availability zone ID, for when the endpoint mode is customer managed.
        """
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[_builtins.str]:
        """
        The subnet id, for when the endpoint mode is service managed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class NgfwUserId(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "agentName":
            suggest = "agent_name"
        elif key == "collectorName":
            suggest = "collector_name"
        elif key == "customIncludeExcludeNetworks":
            suggest = "custom_include_exclude_networks"
        elif key == "secretKeyArn":
            suggest = "secret_key_arn"
        elif key == "userIdStatus":
            suggest = "user_id_status"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwUserId. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwUserId.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwUserId.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 port: _builtins.int,
                 agent_name: Optional[_builtins.str] = None,
                 collector_name: Optional[_builtins.str] = None,
                 custom_include_exclude_networks: Optional[Sequence['outputs.NgfwUserIdCustomIncludeExcludeNetwork']] = None,
                 secret_key_arn: Optional[_builtins.str] = None,
                 user_id_status: Optional[_builtins.str] = None):
        """
        :param _builtins.bool enabled: Enable UserID Config
        :param _builtins.int port: The Port
        :param _builtins.str agent_name: Agent Name for UserID
        :param _builtins.str collector_name: The Collector Name
        :param Sequence['NgfwUserIdCustomIncludeExcludeNetworkArgs'] custom_include_exclude_networks: List of Custom Include Exclude Networks
        :param _builtins.str secret_key_arn: AWS Secret Key ARN
        :param _builtins.str user_id_status: Status and State of UserID Configuration
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "port", port)
        if agent_name is not None:
            pulumi.set(__self__, "agent_name", agent_name)
        if collector_name is not None:
            pulumi.set(__self__, "collector_name", collector_name)
        if custom_include_exclude_networks is not None:
            pulumi.set(__self__, "custom_include_exclude_networks", custom_include_exclude_networks)
        if secret_key_arn is not None:
            pulumi.set(__self__, "secret_key_arn", secret_key_arn)
        if user_id_status is not None:
            pulumi.set(__self__, "user_id_status", user_id_status)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable UserID Config
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The Port
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="agentName")
    def agent_name(self) -> Optional[_builtins.str]:
        """
        Agent Name for UserID
        """
        return pulumi.get(self, "agent_name")

    @_builtins.property
    @pulumi.getter(name="collectorName")
    def collector_name(self) -> Optional[_builtins.str]:
        """
        The Collector Name
        """
        return pulumi.get(self, "collector_name")

    @_builtins.property
    @pulumi.getter(name="customIncludeExcludeNetworks")
    def custom_include_exclude_networks(self) -> Optional[Sequence['outputs.NgfwUserIdCustomIncludeExcludeNetwork']]:
        """
        List of Custom Include Exclude Networks
        """
        return pulumi.get(self, "custom_include_exclude_networks")

    @_builtins.property
    @pulumi.getter(name="secretKeyArn")
    def secret_key_arn(self) -> Optional[_builtins.str]:
        """
        AWS Secret Key ARN
        """
        return pulumi.get(self, "secret_key_arn")

    @_builtins.property
    @pulumi.getter(name="userIdStatus")
    def user_id_status(self) -> Optional[_builtins.str]:
        """
        Status and State of UserID Configuration
        """
        return pulumi.get(self, "user_id_status")


@pulumi.output_type
class NgfwUserIdCustomIncludeExcludeNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "discoveryInclude":
            suggest = "discovery_include"
        elif key == "networkAddress":
            suggest = "network_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NgfwUserIdCustomIncludeExcludeNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NgfwUserIdCustomIncludeExcludeNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NgfwUserIdCustomIncludeExcludeNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 discovery_include: _builtins.bool,
                 enabled: _builtins.bool,
                 name: _builtins.str,
                 network_address: _builtins.str):
        """
        :param _builtins.bool discovery_include: Include or exclude this subnet from user-id configuration
        :param _builtins.bool enabled: Enable this specific custom include/exclude network
        :param _builtins.str name: Name of subnet filter
        :param _builtins.str network_address: Network IP address of the subnet filter
        """
        pulumi.set(__self__, "discovery_include", discovery_include)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_address", network_address)

    @_builtins.property
    @pulumi.getter(name="discoveryInclude")
    def discovery_include(self) -> _builtins.bool:
        """
        Include or exclude this subnet from user-id configuration
        """
        return pulumi.get(self, "discovery_include")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable this specific custom include/exclude network
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of subnet filter
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> _builtins.str:
        """
        Network IP address of the subnet filter
        """
        return pulumi.get(self, "network_address")


@pulumi.output_type
class RulestackProfileConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "antiSpyware":
            suggest = "anti_spyware"
        elif key == "antiVirus":
            suggest = "anti_virus"
        elif key == "fileBlocking":
            suggest = "file_blocking"
        elif key == "outboundTrustCertificate":
            suggest = "outbound_trust_certificate"
        elif key == "outboundUntrustCertificate":
            suggest = "outbound_untrust_certificate"
        elif key == "urlFiltering":
            suggest = "url_filtering"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RulestackProfileConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RulestackProfileConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RulestackProfileConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 anti_spyware: Optional[_builtins.str] = None,
                 anti_virus: Optional[_builtins.str] = None,
                 file_blocking: Optional[_builtins.str] = None,
                 outbound_trust_certificate: Optional[_builtins.str] = None,
                 outbound_untrust_certificate: Optional[_builtins.str] = None,
                 url_filtering: Optional[_builtins.str] = None,
                 vulnerability: Optional[_builtins.str] = None):
        """
        :param _builtins.str anti_spyware: Anti-spyware profile setting. Defaults to `BestPractice`.
        :param _builtins.str anti_virus: Anti-virus profile setting. Defaults to `BestPractice`.
        :param _builtins.str file_blocking: File blocking profile setting. Defaults to `BestPractice`.
        :param _builtins.str outbound_trust_certificate: Outbound trust certificate.
        :param _builtins.str outbound_untrust_certificate: Outbound untrust certificate.
        :param _builtins.str url_filtering: URL filtering profile setting. Defaults to `None`.
        :param _builtins.str vulnerability: Vulnerability profile setting. Defaults to `BestPractice`.
        """
        if anti_spyware is not None:
            pulumi.set(__self__, "anti_spyware", anti_spyware)
        if anti_virus is not None:
            pulumi.set(__self__, "anti_virus", anti_virus)
        if file_blocking is not None:
            pulumi.set(__self__, "file_blocking", file_blocking)
        if outbound_trust_certificate is not None:
            pulumi.set(__self__, "outbound_trust_certificate", outbound_trust_certificate)
        if outbound_untrust_certificate is not None:
            pulumi.set(__self__, "outbound_untrust_certificate", outbound_untrust_certificate)
        if url_filtering is not None:
            pulumi.set(__self__, "url_filtering", url_filtering)
        if vulnerability is not None:
            pulumi.set(__self__, "vulnerability", vulnerability)

    @_builtins.property
    @pulumi.getter(name="antiSpyware")
    def anti_spyware(self) -> Optional[_builtins.str]:
        """
        Anti-spyware profile setting. Defaults to `BestPractice`.
        """
        return pulumi.get(self, "anti_spyware")

    @_builtins.property
    @pulumi.getter(name="antiVirus")
    def anti_virus(self) -> Optional[_builtins.str]:
        """
        Anti-virus profile setting. Defaults to `BestPractice`.
        """
        return pulumi.get(self, "anti_virus")

    @_builtins.property
    @pulumi.getter(name="fileBlocking")
    def file_blocking(self) -> Optional[_builtins.str]:
        """
        File blocking profile setting. Defaults to `BestPractice`.
        """
        return pulumi.get(self, "file_blocking")

    @_builtins.property
    @pulumi.getter(name="outboundTrustCertificate")
    def outbound_trust_certificate(self) -> Optional[_builtins.str]:
        """
        Outbound trust certificate.
        """
        return pulumi.get(self, "outbound_trust_certificate")

    @_builtins.property
    @pulumi.getter(name="outboundUntrustCertificate")
    def outbound_untrust_certificate(self) -> Optional[_builtins.str]:
        """
        Outbound untrust certificate.
        """
        return pulumi.get(self, "outbound_untrust_certificate")

    @_builtins.property
    @pulumi.getter(name="urlFiltering")
    def url_filtering(self) -> Optional[_builtins.str]:
        """
        URL filtering profile setting. Defaults to `None`.
        """
        return pulumi.get(self, "url_filtering")

    @_builtins.property
    @pulumi.getter
    def vulnerability(self) -> Optional[_builtins.str]:
        """
        Vulnerability profile setting. Defaults to `BestPractice`.
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class SecurityRuleCategory(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "urlCategoryNames":
            suggest = "url_category_names"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleCategory. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleCategory.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleCategory.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 feeds: Optional[Sequence[_builtins.str]] = None,
                 url_category_names: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] url_category_names: List of URL category names.
        """
        if feeds is not None:
            pulumi.set(__self__, "feeds", feeds)
        if url_category_names is not None:
            pulumi.set(__self__, "url_category_names", url_category_names)

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="urlCategoryNames")
    def url_category_names(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of URL category names.
        """
        return pulumi.get(self, "url_category_names")


@pulumi.output_type
class SecurityRuleDestination(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fqdnLists":
            suggest = "fqdn_lists"
        elif key == "prefixLists":
            suggest = "prefix_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleDestination. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleDestination.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleDestination.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidrs: Optional[Sequence[_builtins.str]] = None,
                 countries: Optional[Sequence[_builtins.str]] = None,
                 feeds: Optional[Sequence[_builtins.str]] = None,
                 fqdn_lists: Optional[Sequence[_builtins.str]] = None,
                 prefix_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] cidrs: List of CIDRs.
        :param Sequence[_builtins.str] countries: List of countries.
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] fqdn_lists: List of FQDN lists.
        :param Sequence[_builtins.str] prefix_lists: List of prefix list.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)
        if feeds is not None:
            pulumi.set(__self__, "feeds", feeds)
        if fqdn_lists is not None:
            pulumi.set(__self__, "fqdn_lists", fqdn_lists)
        if prefix_lists is not None:
            pulumi.set(__self__, "prefix_lists", prefix_lists)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of countries.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="fqdnLists")
    def fqdn_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of FQDN lists.
        """
        return pulumi.get(self, "fqdn_lists")

    @_builtins.property
    @pulumi.getter(name="prefixLists")
    def prefix_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of prefix list.
        """
        return pulumi.get(self, "prefix_lists")


@pulumi.output_type
class SecurityRuleSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "prefixLists":
            suggest = "prefix_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityRuleSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityRuleSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityRuleSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cidrs: Optional[Sequence[_builtins.str]] = None,
                 countries: Optional[Sequence[_builtins.str]] = None,
                 feeds: Optional[Sequence[_builtins.str]] = None,
                 prefix_lists: Optional[Sequence[_builtins.str]] = None):
        """
        :param Sequence[_builtins.str] cidrs: List of CIDRs.
        :param Sequence[_builtins.str] countries: List of countries.
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] prefix_lists: List of prefix list.
        """
        if cidrs is not None:
            pulumi.set(__self__, "cidrs", cidrs)
        if countries is not None:
            pulumi.set(__self__, "countries", countries)
        if feeds is not None:
            pulumi.set(__self__, "feeds", feeds)
        if prefix_lists is not None:
            pulumi.set(__self__, "prefix_lists", prefix_lists)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of countries.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="prefixLists")
    def prefix_lists(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of prefix list.
        """
        return pulumi.get(self, "prefix_lists")


@pulumi.output_type
class GetAccountsAccountDetailResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.str,
                 external_id: _builtins.str,
                 onboarding_status: _builtins.str):
        """
        :param _builtins.str account_id: The account id.
        :param _builtins.str external_id: External Id of the onboarded account
        :param _builtins.str onboarding_status: Onboarding status of the account.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "external_id", external_id)
        pulumi.set(__self__, "onboarding_status", onboarding_status)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account id.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="externalId")
    def external_id(self) -> _builtins.str:
        """
        External Id of the onboarded account
        """
        return pulumi.get(self, "external_id")

    @_builtins.property
    @pulumi.getter(name="onboardingStatus")
    def onboarding_status(self) -> _builtins.str:
        """
        Onboarding status of the account.
        """
        return pulumi.get(self, "onboarding_status")


@pulumi.output_type
class GetNgfwEgressNatResult(dict):
    def __init__(__self__, *,
                 enabled: _builtins.bool,
                 settings: Sequence['outputs.GetNgfwEgressNatSettingResult']):
        """
        :param _builtins.bool enabled: Enable egress NAT
        """
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "settings", settings)

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable egress NAT
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def settings(self) -> Sequence['outputs.GetNgfwEgressNatSettingResult']:
        return pulumi.get(self, "settings")


@pulumi.output_type
class GetNgfwEgressNatSettingResult(dict):
    def __init__(__self__, *,
                 ip_pool_type: _builtins.str,
                 ipam_pool_id: _builtins.str):
        """
        :param _builtins.str ip_pool_type: Set ip pool type from the following options. Valid values are `AWSService` or `BYOIP`.
        :param _builtins.str ipam_pool_id: The IP pool ID
        """
        pulumi.set(__self__, "ip_pool_type", ip_pool_type)
        pulumi.set(__self__, "ipam_pool_id", ipam_pool_id)

    @_builtins.property
    @pulumi.getter(name="ipPoolType")
    def ip_pool_type(self) -> _builtins.str:
        """
        Set ip pool type from the following options. Valid values are `AWSService` or `BYOIP`.
        """
        return pulumi.get(self, "ip_pool_type")

    @_builtins.property
    @pulumi.getter(name="ipamPoolId")
    def ipam_pool_id(self) -> _builtins.str:
        """
        The IP pool ID
        """
        return pulumi.get(self, "ipam_pool_id")


@pulumi.output_type
class GetNgfwEndpointResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.str,
                 egress_nat_enabled: _builtins.bool,
                 endpoint_id: _builtins.str,
                 mode: _builtins.str,
                 prefixes: Sequence['outputs.GetNgfwEndpointPrefixResult'],
                 rejected_reason: _builtins.str,
                 status: _builtins.str,
                 subnet_id: _builtins.str,
                 vpc_id: _builtins.str,
                 zone_id: _builtins.str):
        """
        :param _builtins.str account_id: The account id.
        :param _builtins.bool egress_nat_enabled: Enable egress NAT
        :param _builtins.str endpoint_id: Endpoint ID of the security zone
        :param _builtins.str mode: The endpoint mode. Valid values are `ServiceManaged` or `CustomerManaged`.
        :param _builtins.str rejected_reason: The rejected reason.
        :param _builtins.str status: The attachment status.
        :param _builtins.str subnet_id: The subnet id.
        :param _builtins.str vpc_id: The vpc id.
        :param _builtins.str zone_id: The AZ id.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "egress_nat_enabled", egress_nat_enabled)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "prefixes", prefixes)
        pulumi.set(__self__, "rejected_reason", rejected_reason)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        The account id.
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="egressNatEnabled")
    def egress_nat_enabled(self) -> _builtins.bool:
        """
        Enable egress NAT
        """
        return pulumi.get(self, "egress_nat_enabled")

    @_builtins.property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> _builtins.str:
        """
        Endpoint ID of the security zone
        """
        return pulumi.get(self, "endpoint_id")

    @_builtins.property
    @pulumi.getter
    def mode(self) -> _builtins.str:
        """
        The endpoint mode. Valid values are `ServiceManaged` or `CustomerManaged`.
        """
        return pulumi.get(self, "mode")

    @_builtins.property
    @pulumi.getter
    def prefixes(self) -> Sequence['outputs.GetNgfwEndpointPrefixResult']:
        return pulumi.get(self, "prefixes")

    @_builtins.property
    @pulumi.getter(name="rejectedReason")
    def rejected_reason(self) -> _builtins.str:
        """
        The rejected reason.
        """
        return pulumi.get(self, "rejected_reason")

    @_builtins.property
    @pulumi.getter
    def status(self) -> _builtins.str:
        """
        The attachment status.
        """
        return pulumi.get(self, "status")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The subnet id.
        """
        return pulumi.get(self, "subnet_id")

    @_builtins.property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> _builtins.str:
        """
        The vpc id.
        """
        return pulumi.get(self, "vpc_id")

    @_builtins.property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> _builtins.str:
        """
        The AZ id.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class GetNgfwEndpointPrefixResult(dict):
    def __init__(__self__, *,
                 private_prefixes: Sequence['outputs.GetNgfwEndpointPrefixPrivatePrefixResult']):
        pulumi.set(__self__, "private_prefixes", private_prefixes)

    @_builtins.property
    @pulumi.getter(name="privatePrefixes")
    def private_prefixes(self) -> Sequence['outputs.GetNgfwEndpointPrefixPrivatePrefixResult']:
        return pulumi.get(self, "private_prefixes")


@pulumi.output_type
class GetNgfwEndpointPrefixPrivatePrefixResult(dict):
    def __init__(__self__, *,
                 cidrs: Sequence[_builtins.str]):
        pulumi.set(__self__, "cidrs", cidrs)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Sequence[_builtins.str]:
        return pulumi.get(self, "cidrs")


@pulumi.output_type
class GetNgfwLogProfileLogConfigResult(dict):
    def __init__(__self__, *,
                 account_id: _builtins.str,
                 log_destination: _builtins.str,
                 log_destination_type: _builtins.str,
                 log_types: Sequence[_builtins.str],
                 role_type: _builtins.str):
        """
        :param _builtins.str account_id: Type of Role for log configuration
        :param _builtins.str log_destination: The log destination details.
        :param _builtins.str log_destination_type: The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        :param Sequence[_builtins.str] log_types: The list of different log types that are wanted
        :param _builtins.str role_type: Type of Role for log configuration
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "log_destination", log_destination)
        pulumi.set(__self__, "log_destination_type", log_destination_type)
        pulumi.set(__self__, "log_types", log_types)
        pulumi.set(__self__, "role_type", role_type)

    @_builtins.property
    @pulumi.getter(name="accountId")
    def account_id(self) -> _builtins.str:
        """
        Type of Role for log configuration
        """
        return pulumi.get(self, "account_id")

    @_builtins.property
    @pulumi.getter(name="logDestination")
    def log_destination(self) -> _builtins.str:
        """
        The log destination details.
        """
        return pulumi.get(self, "log_destination")

    @_builtins.property
    @pulumi.getter(name="logDestinationType")
    def log_destination_type(self) -> _builtins.str:
        """
        The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        """
        return pulumi.get(self, "log_destination_type")

    @_builtins.property
    @pulumi.getter(name="logTypes")
    def log_types(self) -> Sequence[_builtins.str]:
        """
        The list of different log types that are wanted
        """
        return pulumi.get(self, "log_types")

    @_builtins.property
    @pulumi.getter(name="roleType")
    def role_type(self) -> _builtins.str:
        """
        Type of Role for log configuration
        """
        return pulumi.get(self, "role_type")


@pulumi.output_type
class GetNgfwLogProfileLogDestinationResult(dict):
    def __init__(__self__, *,
                 destination: _builtins.str,
                 destination_type: _builtins.str,
                 log_type: _builtins.str):
        """
        :param _builtins.str destination: The log destination details.
        :param _builtins.str destination_type: The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        :param _builtins.str log_type: The type of logs. Valid values are `TRAFFIC`, `THREAT`, or `DECRYPTION`.
        """
        pulumi.set(__self__, "destination", destination)
        pulumi.set(__self__, "destination_type", destination_type)
        pulumi.set(__self__, "log_type", log_type)

    @_builtins.property
    @pulumi.getter
    def destination(self) -> _builtins.str:
        """
        The log destination details.
        """
        return pulumi.get(self, "destination")

    @_builtins.property
    @pulumi.getter(name="destinationType")
    def destination_type(self) -> _builtins.str:
        """
        The log destination type. Valid values are `S3`, `CloudWatchLogs`, or `KinesisDataFirehose`.
        """
        return pulumi.get(self, "destination_type")

    @_builtins.property
    @pulumi.getter(name="logType")
    def log_type(self) -> _builtins.str:
        """
        The type of logs. Valid values are `TRAFFIC`, `THREAT`, or `DECRYPTION`.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class GetNgfwPrivateAccessResult(dict):
    def __init__(__self__, *,
                 resource_id: _builtins.str,
                 type: _builtins.str):
        """
        :param _builtins.str resource_id: AWS ResourceID
        :param _builtins.str type: Type of Private Access
        """
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> _builtins.str:
        """
        AWS ResourceID
        """
        return pulumi.get(self, "resource_id")

    @_builtins.property
    @pulumi.getter
    def type(self) -> _builtins.str:
        """
        Type of Private Access
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNgfwStatusResult(dict):
    def __init__(__self__, *,
                 device_rulestack_commit_status: _builtins.str,
                 failure_reason: _builtins.str,
                 firewall_status: _builtins.str,
                 rulestack_status: _builtins.str):
        """
        :param _builtins.str device_rulestack_commit_status: The device rulestack commit status.
        :param _builtins.str failure_reason: The firewall failure reason.
        :param _builtins.str firewall_status: The firewall status.
        :param _builtins.str rulestack_status: The rulestack status.
        """
        pulumi.set(__self__, "device_rulestack_commit_status", device_rulestack_commit_status)
        pulumi.set(__self__, "failure_reason", failure_reason)
        pulumi.set(__self__, "firewall_status", firewall_status)
        pulumi.set(__self__, "rulestack_status", rulestack_status)

    @_builtins.property
    @pulumi.getter(name="deviceRulestackCommitStatus")
    def device_rulestack_commit_status(self) -> _builtins.str:
        """
        The device rulestack commit status.
        """
        return pulumi.get(self, "device_rulestack_commit_status")

    @_builtins.property
    @pulumi.getter(name="failureReason")
    def failure_reason(self) -> _builtins.str:
        """
        The firewall failure reason.
        """
        return pulumi.get(self, "failure_reason")

    @_builtins.property
    @pulumi.getter(name="firewallStatus")
    def firewall_status(self) -> _builtins.str:
        """
        The firewall status.
        """
        return pulumi.get(self, "firewall_status")

    @_builtins.property
    @pulumi.getter(name="rulestackStatus")
    def rulestack_status(self) -> _builtins.str:
        """
        The rulestack status.
        """
        return pulumi.get(self, "rulestack_status")


@pulumi.output_type
class GetNgfwSubnetMappingResult(dict):
    def __init__(__self__, *,
                 availability_zone: _builtins.str,
                 availability_zone_id: _builtins.str,
                 subnet_id: _builtins.str):
        """
        :param _builtins.str availability_zone: The availability zone, for when the endpoint mode is customer managed.
        :param _builtins.str availability_zone_id: The availability zone ID, for when the endpoint mode is customer managed.
        :param _builtins.str subnet_id: The subnet id, for when the endpoint mode is service managed.
        """
        pulumi.set(__self__, "availability_zone", availability_zone)
        pulumi.set(__self__, "availability_zone_id", availability_zone_id)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @_builtins.property
    @pulumi.getter(name="availabilityZone")
    def availability_zone(self) -> _builtins.str:
        """
        The availability zone, for when the endpoint mode is customer managed.
        """
        return pulumi.get(self, "availability_zone")

    @_builtins.property
    @pulumi.getter(name="availabilityZoneId")
    def availability_zone_id(self) -> _builtins.str:
        """
        The availability zone ID, for when the endpoint mode is customer managed.
        """
        return pulumi.get(self, "availability_zone_id")

    @_builtins.property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> _builtins.str:
        """
        The subnet id, for when the endpoint mode is service managed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNgfwUserIdResult(dict):
    def __init__(__self__, *,
                 agent_name: _builtins.str,
                 collector_name: _builtins.str,
                 custom_include_exclude_networks: Sequence['outputs.GetNgfwUserIdCustomIncludeExcludeNetworkResult'],
                 enabled: _builtins.bool,
                 port: _builtins.int,
                 secret_key_arn: _builtins.str,
                 user_id_status: _builtins.str):
        """
        :param _builtins.str agent_name: Agent Name for UserID
        :param _builtins.str collector_name: The Collector Name
        :param Sequence['GetNgfwUserIdCustomIncludeExcludeNetworkArgs'] custom_include_exclude_networks: List of Custom Include Exclude Networks
        :param _builtins.bool enabled: Enable UserID Config
        :param _builtins.int port: The Port
        :param _builtins.str secret_key_arn: AWS Secret Key ARN
        :param _builtins.str user_id_status: Status and State of UserID Configuration
        """
        pulumi.set(__self__, "agent_name", agent_name)
        pulumi.set(__self__, "collector_name", collector_name)
        pulumi.set(__self__, "custom_include_exclude_networks", custom_include_exclude_networks)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "secret_key_arn", secret_key_arn)
        pulumi.set(__self__, "user_id_status", user_id_status)

    @_builtins.property
    @pulumi.getter(name="agentName")
    def agent_name(self) -> _builtins.str:
        """
        Agent Name for UserID
        """
        return pulumi.get(self, "agent_name")

    @_builtins.property
    @pulumi.getter(name="collectorName")
    def collector_name(self) -> _builtins.str:
        """
        The Collector Name
        """
        return pulumi.get(self, "collector_name")

    @_builtins.property
    @pulumi.getter(name="customIncludeExcludeNetworks")
    def custom_include_exclude_networks(self) -> Sequence['outputs.GetNgfwUserIdCustomIncludeExcludeNetworkResult']:
        """
        List of Custom Include Exclude Networks
        """
        return pulumi.get(self, "custom_include_exclude_networks")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable UserID Config
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def port(self) -> _builtins.int:
        """
        The Port
        """
        return pulumi.get(self, "port")

    @_builtins.property
    @pulumi.getter(name="secretKeyArn")
    def secret_key_arn(self) -> _builtins.str:
        """
        AWS Secret Key ARN
        """
        return pulumi.get(self, "secret_key_arn")

    @_builtins.property
    @pulumi.getter(name="userIdStatus")
    def user_id_status(self) -> _builtins.str:
        """
        Status and State of UserID Configuration
        """
        return pulumi.get(self, "user_id_status")


@pulumi.output_type
class GetNgfwUserIdCustomIncludeExcludeNetworkResult(dict):
    def __init__(__self__, *,
                 discovery_include: _builtins.bool,
                 enabled: _builtins.bool,
                 name: _builtins.str,
                 network_address: _builtins.str):
        """
        :param _builtins.bool discovery_include: Include or exclude this subnet from user-id configuration
        :param _builtins.bool enabled: Enable this specific custom include/exclude network
        :param _builtins.str name: Name of subnet filter
        :param _builtins.str network_address: Network IP address of the subnet filter
        """
        pulumi.set(__self__, "discovery_include", discovery_include)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network_address", network_address)

    @_builtins.property
    @pulumi.getter(name="discoveryInclude")
    def discovery_include(self) -> _builtins.bool:
        """
        Include or exclude this subnet from user-id configuration
        """
        return pulumi.get(self, "discovery_include")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> _builtins.bool:
        """
        Enable this specific custom include/exclude network
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Name of subnet filter
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="networkAddress")
    def network_address(self) -> _builtins.str:
        """
        Network IP address of the subnet filter
        """
        return pulumi.get(self, "network_address")


@pulumi.output_type
class GetNgfwsInstanceResult(dict):
    def __init__(__self__, *,
                 firewall_id: _builtins.str,
                 region: _builtins.str):
        """
        :param _builtins.str firewall_id: The NGFW ID.
        :param _builtins.str region: The region the NGFW is in.
        """
        pulumi.set(__self__, "firewall_id", firewall_id)
        pulumi.set(__self__, "region", region)

    @_builtins.property
    @pulumi.getter(name="firewallId")
    def firewall_id(self) -> _builtins.str:
        """
        The NGFW ID.
        """
        return pulumi.get(self, "firewall_id")

    @_builtins.property
    @pulumi.getter
    def region(self) -> _builtins.str:
        """
        The region the NGFW is in.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class GetRulestackProfileConfigResult(dict):
    def __init__(__self__, *,
                 anti_spyware: _builtins.str,
                 anti_virus: _builtins.str,
                 file_blocking: _builtins.str,
                 outbound_trust_certificate: _builtins.str,
                 outbound_untrust_certificate: _builtins.str,
                 url_filtering: _builtins.str,
                 vulnerability: _builtins.str):
        """
        :param _builtins.str anti_spyware: Anti-spyware profile setting.
        :param _builtins.str anti_virus: Anti-virus profile setting.
        :param _builtins.str file_blocking: File blocking profile setting.
        :param _builtins.str outbound_trust_certificate: Outbound trust certificate.
        :param _builtins.str outbound_untrust_certificate: Outbound untrust certificate.
        :param _builtins.str url_filtering: URL filtering profile setting.
        :param _builtins.str vulnerability: Vulnerability profile setting.
        """
        pulumi.set(__self__, "anti_spyware", anti_spyware)
        pulumi.set(__self__, "anti_virus", anti_virus)
        pulumi.set(__self__, "file_blocking", file_blocking)
        pulumi.set(__self__, "outbound_trust_certificate", outbound_trust_certificate)
        pulumi.set(__self__, "outbound_untrust_certificate", outbound_untrust_certificate)
        pulumi.set(__self__, "url_filtering", url_filtering)
        pulumi.set(__self__, "vulnerability", vulnerability)

    @_builtins.property
    @pulumi.getter(name="antiSpyware")
    def anti_spyware(self) -> _builtins.str:
        """
        Anti-spyware profile setting.
        """
        return pulumi.get(self, "anti_spyware")

    @_builtins.property
    @pulumi.getter(name="antiVirus")
    def anti_virus(self) -> _builtins.str:
        """
        Anti-virus profile setting.
        """
        return pulumi.get(self, "anti_virus")

    @_builtins.property
    @pulumi.getter(name="fileBlocking")
    def file_blocking(self) -> _builtins.str:
        """
        File blocking profile setting.
        """
        return pulumi.get(self, "file_blocking")

    @_builtins.property
    @pulumi.getter(name="outboundTrustCertificate")
    def outbound_trust_certificate(self) -> _builtins.str:
        """
        Outbound trust certificate.
        """
        return pulumi.get(self, "outbound_trust_certificate")

    @_builtins.property
    @pulumi.getter(name="outboundUntrustCertificate")
    def outbound_untrust_certificate(self) -> _builtins.str:
        """
        Outbound untrust certificate.
        """
        return pulumi.get(self, "outbound_untrust_certificate")

    @_builtins.property
    @pulumi.getter(name="urlFiltering")
    def url_filtering(self) -> _builtins.str:
        """
        URL filtering profile setting.
        """
        return pulumi.get(self, "url_filtering")

    @_builtins.property
    @pulumi.getter
    def vulnerability(self) -> _builtins.str:
        """
        Vulnerability profile setting.
        """
        return pulumi.get(self, "vulnerability")


@pulumi.output_type
class GetSecurityRuleCategoryResult(dict):
    def __init__(__self__, *,
                 feeds: Sequence[_builtins.str],
                 url_category_names: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] url_category_names: List of URL category names.
        """
        pulumi.set(__self__, "feeds", feeds)
        pulumi.set(__self__, "url_category_names", url_category_names)

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Sequence[_builtins.str]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="urlCategoryNames")
    def url_category_names(self) -> Sequence[_builtins.str]:
        """
        List of URL category names.
        """
        return pulumi.get(self, "url_category_names")


@pulumi.output_type
class GetSecurityRuleDestinationResult(dict):
    def __init__(__self__, *,
                 cidrs: Sequence[_builtins.str],
                 countries: Sequence[_builtins.str],
                 feeds: Sequence[_builtins.str],
                 fqdn_lists: Sequence[_builtins.str],
                 prefix_lists: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] cidrs: List of CIDRs.
        :param Sequence[_builtins.str] countries: List of countries.
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] fqdn_lists: List of FQDN lists.
        :param Sequence[_builtins.str] prefix_lists: List of prefix list.
        """
        pulumi.set(__self__, "cidrs", cidrs)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "feeds", feeds)
        pulumi.set(__self__, "fqdn_lists", fqdn_lists)
        pulumi.set(__self__, "prefix_lists", prefix_lists)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Sequence[_builtins.str]:
        """
        List of CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence[_builtins.str]:
        """
        List of countries.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Sequence[_builtins.str]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="fqdnLists")
    def fqdn_lists(self) -> Sequence[_builtins.str]:
        """
        List of FQDN lists.
        """
        return pulumi.get(self, "fqdn_lists")

    @_builtins.property
    @pulumi.getter(name="prefixLists")
    def prefix_lists(self) -> Sequence[_builtins.str]:
        """
        List of prefix list.
        """
        return pulumi.get(self, "prefix_lists")


@pulumi.output_type
class GetSecurityRuleSourceResult(dict):
    def __init__(__self__, *,
                 cidrs: Sequence[_builtins.str],
                 countries: Sequence[_builtins.str],
                 feeds: Sequence[_builtins.str],
                 prefix_lists: Sequence[_builtins.str]):
        """
        :param Sequence[_builtins.str] cidrs: List of CIDRs.
        :param Sequence[_builtins.str] countries: List of countries.
        :param Sequence[_builtins.str] feeds: List of feeds.
        :param Sequence[_builtins.str] prefix_lists: List of prefix list.
        """
        pulumi.set(__self__, "cidrs", cidrs)
        pulumi.set(__self__, "countries", countries)
        pulumi.set(__self__, "feeds", feeds)
        pulumi.set(__self__, "prefix_lists", prefix_lists)

    @_builtins.property
    @pulumi.getter
    def cidrs(self) -> Sequence[_builtins.str]:
        """
        List of CIDRs.
        """
        return pulumi.get(self, "cidrs")

    @_builtins.property
    @pulumi.getter
    def countries(self) -> Sequence[_builtins.str]:
        """
        List of countries.
        """
        return pulumi.get(self, "countries")

    @_builtins.property
    @pulumi.getter
    def feeds(self) -> Sequence[_builtins.str]:
        """
        List of feeds.
        """
        return pulumi.get(self, "feeds")

    @_builtins.property
    @pulumi.getter(name="prefixLists")
    def prefix_lists(self) -> Sequence[_builtins.str]:
        """
        List of prefix list.
        """
        return pulumi.get(self, "prefix_lists")


