#!/usr/bin/env python

# Edited by amiro and eterzic 25.01.2021

from __future__ import print_function, division

import os, numpy as np

from .entities import Basin

med    = Basin.from_array('med'  , 'Mediterranean Sea'    , np.array([[-5.71, 36.10 , 0.],[3.16 , 45.03 , 0.],[15.56, 46.98 , 0.],[28.39, 41.24 , 0.],[33.49, 40.45 , 0.],[37.53, 36.32 , 0.],[35.77, 30.75 , 0.],[29.79, 30.22 , 0.],[19.25, 29.38 , 0.],[-3.78, 33.94 , 0.],[-5.54, 34.45 , 0.]]))
wmed   = Basin.from_array('wmed' , 'Western Mediterranean', np.array([[-5.80, 36.14,0.],[ 4.00, 44.50,0.],[11.69, 44.56,0.],[16.88, 39.02,0.],[14.50, 37.75,0.],[14.94, 36.70,0.],[15.07, 32.10,0.],[-5.67, 34.89,0.]]))
emed   = Basin.from_array('emed' , 'Eastern Mediterranean', np.array([[15.12, 36.91, 0.],[15.07, 32.29, 0.],[17.49, 30.07, 0.],[21.97, 30.60, 0.],[37.88, 30.07, 0.],[36.91, 37.23, 0.],[31.82, 40.38, 0.],[29.27, 41.05, 0.],[25.22, 42.03, 0.],[19.51, 43.77, 0.],[15.82, 45.71, 0.],[13.62, 45.77, 0.],[12.30, 45.64, 0.],[11.51, 45.21, 0.]]))
adr    = Basin.from_array('adr'  , 'Adriatic'             , np.array([[18.3636474609375,   39.816975090490004, 0.],[20.14892578125,     39.80431612840032,  0.],[19.819335937499996, 42.08191667830631,  0.],[13.798828125,       46.255846818480315, 0.],[11.074218749999998, 45.398449976304086, 0.],[13.095703125,       42.42345651793833,  0.],[18.1494140625,      40.287906612507406, 0.]]))

socean = Basin.from_array('so'   , 'Southern Ocean'       , np.array([[60.64, -47.52 , 0.],[79.01, -47.28 , 0.],[78.50, -57.61 , 0.],[61.70, -56.80 , 0.]]))
natla1 = Basin.from_array('na1'  , 'North Atlantic Ocean' , np.array([[-43.9013671875,60.34869562531862,0.],[-43.681640625,65.67638148211446,0.],[-34.1015625,68.17155518732503,0.],[-18.45703125,63.66576033778838,0.],[-31.201171875,55.02802211299252,0.]]))
matlan = Basin.from_array('ma'   , 'Mid Atlantic Ocean'   , np.array([[-39.111328125,-21.943045533438166,0.],[-36.298828125,-11.178401873711772,0.],[-20.390625,-11.436955216143177,0.],[-21.357421875,-24.846565348219745,0.]]))
black  = Basin.from_array('black', 'Black Sea'            , np.array([[27.48779296875,41.508577297439324,0.],[31.26708984375,40.84706035607122,0.],[33.57421875,41.75492216766298,0.],[38.69384765625,40.6306300839918,0.],[41.28662109375,41.062786068733026,0.],[42.1875,42.01665183556825,0.],[41.55029296875,43.1811470593997,0.],[37.177734375,45.19752230305682,0.],[34.453125,45.24395342262324,0.],[33.28857421875,46.52863469527167,0.],[30.95947265625,47.025206001585396,0.],[28.037109375,44.84029065139799,0.]]))
red    = Basin.from_array('red'  , 'Red Sea'              , np.array([[32.255859375,30.14512718337613 ,0.],[35.244140625,29.802517905764475,0.],[44.78027343749999,13.624633438236152,0.],[41.66015625,12.039320557540572,0.],[31.113281249999996,27.21555620902969,0.]]))
labsea = Basin.from_array('labr' , 'Labrador Sea'         , np.array([[-63.80859374999999,66.51326044311185,0.],[-51.328125,67.2720426739952,0.],[-43.9453125,60.23981116999893,0.],[-57.65624999999999,52.5897007687178,0.],[-64.86328125,58.722598828043374,0.]]))
baffin = Basin.from_array('baff' , 'Baffin Bay'           , np.array([[-63.45703124999999,66.37275500247455,0.],[-47.8125,67.40748724648753,0.],[-59.765625,81.72318761821155,0.],[-68.37890625,81.84875563107857,0.],[-91.40625,75.05035357407698,0.]]))
grnsea = Basin.from_array('gsea' , 'Greenland Sea'        , np.array([[-30.05859375,70.19999407534661,0.],[-8.349609375,71.01695975726373,0.],[16.5234375,76.70001918871924,0.],[17.666015625,78.66460771205898,0.],[11.865234375,79.68718415450823,0.],[-22.412109375,79.99716840285255,0.]]))
dstra  = Basin.from_array('dstra', 'Denmark Strait'       , np.array([[-30.585937499999996,69.25614923150721,0.],[-23.115234374999996,70.08056215839737,0.],[-16.083984375,66.40795547978848,0.],[-18.45703125,65.10914820386473,0.],[-22.8515625,64.92354174306496,0.],[-36.650390625,67.87554134672945,0.]]))
norsea = Basin.from_array('norw' , 'Norwegian Sea'        , np.array([[-18.896484375,63.6267446447533,0.],[-8.525390625,71.07405646336098,0.],[16.5234375,76.67978490310692,0.],[27.24609375,70.28911664330674,0.],[6.240234374999999,58.859223547066584,0.]]))
sarsea = Basin.from_array('sarg' , 'Sargasso Sea'         , np.array([[-80.419921875,22.63429269379353,0.],[-82.265625,31.765537409484374,0.],[-77.3876953125,35.567980458012094,0.],[-64.7314453125,32.287132632616384,0.],[-51.328125,26.62781822639305,0.],[-66.005859375,18.104087015773946,0.],[-73.0810546875,19.766703551716976,0.]]))
cverde = Basin.from_array('cverd', 'Cape Verde'           , np.array([[-30.25634765625,18.87510275035649,0.],[-21.59912109375,18.79191774423444,0.],[-21.51123046875,10.379765224421455,0.],[-30.849609375,10.660607953624776,0.]]))
scosea = Basin.from_array('scot' , 'Scotia Sea'           , np.array([[-65.6103515625,-54.77534585936447,0.],[-59.8974609375,-51.6452940493054,0.],[-37.1337890625,-54.1881554810715,0.],[-45.52734375,-60.586967342258674,0.],[-55.1953125,-61.12201916813025,0.]]))
poli   = Basin.from_array('polin', 'Polinesia'            , np.array([[-169.27734375,-11.523087506868514,0.],[-169.365234375,-24.766784522874428,0.],[-135.87890625,-25.165173368663943,0.],[-135.966796875,-11.781325296112277,0.]]))

world  = Basin.from_array('world', 'World'                , np.array([[-180.0,-90.0,0.0],[180.0,-90.0,0.0],[180.0,90.0,0.0],[-180.0,90.0,0.0]]))

kotor  = Basin.from_array('kotor', 'Bay of Kotor'         , np.array([[18.48, 42.51, 0.],[18.48, 42.43, 0.],[18.52, 42.40, 0.],[18.58, 42.39, 0.],[18.78, 42.39, 0.],[18.78, 42.49, 0.],[18.69, 42.52, 0.]]))

del print_function, division, os, np, Basin