from setuptools import setup, find_packages

setup(
    name="novig_liquidity",
    version="1.0.5",
    description="A Python wrapper for the Novig API with built-in filtering and liquidity validation.",
    author="Devon H",
    url="https://github.com/Hurteau101/Novig_Liquidity_Template",
    license="MIT",
    packages=find_packages(include=["novig", "novig.*"]),
    install_requires=[
        "aiohappyeyeballs==2.6.1",
        "aiohttp==3.12.15",
        "aiosignal==1.4.0",
        "annotated-types==0.7.0",
        "attrs==25.3.0",
        "certifi==2025.8.3",
        "charset-normalizer==3.4.3",
        "frozenlist==1.7.0",
        "idna==3.10",
        "multidict==6.6.4",
        "propcache==0.3.2",
        "pydantic==2.11.9",
        "pydantic_core==2.33.2",
        "redis==6.4.0",
        "requests==2.32.5",
        "typing-inspection==0.4.1",
        "typing_extensions==4.15.0",
        "urllib3==2.5.0",
        "yarl==1.20.1",
    ],
    python_requires=">=3.8",
    include_package_data=True,
    long_description=open("README.md", encoding="utf-8").read(),
    long_description_content_type="text/markdown",
)
