# SuperGemini Quick Start Practices

**Essential SuperGemini Fundamentals**: Core practices for immediate productivity gains. Master these foundations to build confidence and establish effective development workflows from day one.

**Focus**: Quick wins, essential commands, basic workflows, and session management fundamentals for new users.

## Table of Contents

### Foundation Essentials
- [Getting Started Right](#getting-started-right) - Essential onboarding and workflow patterns
- [Command Fundamentals](#command-fundamentals) - Core command mastery and selection
- [Basic Flag Usage](#basic-flag-usage) - Essential flags for immediate productivity
- [Session Management Basics](#session-management-basics) - Context preservation fundamentals

### Quick Wins
- [Daily Workflow Patterns](#daily-workflow-patterns) - Proven daily development routines
- [First Week Learning Path](#first-week-learning-path) - Structured skill development
- [Common Quick Fixes](#common-quick-fixes) - Immediate problem resolution

### See Also
- [Advanced Patterns](advanced-patterns.md) - Multi-agent coordination and expert techniques
- [Optimization Guide](optimization-guide.md) - Performance and efficiency strategies

## Getting Started Right

### Foundation Principles

**Start Simple, Scale Intelligently:**
```bash
# Week 1: Master these essential commands
/sg:brainstorm "vague project idea"      # Requirements discovery
/sg:analyze existing-code/               # Code understanding  
/sg:implement "specific feature"         # Feature development
/sg:test --coverage                      # Quality validation

# Week 2-3: Add coordination
/sg:workflow "complex feature"           # Planning workflows
/sg:improve . --focus quality            # Code improvement
/sg:document . --scope project           # Documentation

# Week 4+: Master optimization
/sg:analyze . --ultrathink --all-mcp     # Advanced analysis
/sg:spawn "enterprise project" --orchestrate  # Complex coordination
```

### Progressive Learning Path

**Phase 1: Command Fundamentals (Days 1-7)**
```bash
# Daily practice routine
Day 1: /sg:brainstorm "daily coding challenge"
Day 2: /sg:analyze sample-project/ --focus quality
Day 3: /sg:implement "simple CRUD API"
Day 4: /sg:test --type unit --coverage
Day 5: /sg:improve previous-work/ --safe-mode
Day 6: /sg:document your-project/ --scope project
Day 7: /sg:workflow "week 2 learning plan"

# Success metrics: Comfort with basic commands, understanding of output
```

**Phase 2: Intelligent Coordination (Days 8-21)**
```bash
# Multi-agent workflow practice
/sg:implement "secure user authentication with testing and documentation"
# Should activate: security-engineer + backend-architect + quality-engineer + technical-writer

# Mode optimization practice
/sg:brainstorm "complex project requirements"  # Brainstorming mode
/sg:spawn "multi-service architecture"         # Task management mode
/sg:analyze performance-issues/ --introspect   # Introspection mode

# Success metrics: Multi-agent coordination understanding, mode awareness
```

**Phase 3: Session and Persistence (Days 22-30)**
```bash
# Long-term project simulation
/sg:load new-project/ --scope project
/sg:save "project-baseline"

# Daily development cycle
/sg:load "project-baseline"
/sg:implement "daily feature"
/sg:test --integration
/sg:save "day-$(date +%m%d)-complete"

# Success metrics: Session management, context preservation, project continuity
```

### Effective Onboarding Patterns

**First Session Optimization:**
```bash
# Optimal first session workflow
/sg:load your-project/                    # Establish project context
/sg:analyze . --scope project             # Understand codebase
/sg:document . --scope project            # Generate project overview
/sg:save "onboarding-complete"           # Save initial understanding

# Expected outcomes:
# - Complete project understanding documented
# - Architecture and quality baseline established  
# - Session context ready for productive development
# - Foundation for all future work sessions
```

**Daily Workflow Establishment:**
```bash
# Proven daily startup routine
/sg:load "current-project"               # Restore context
/sg:reflect "yesterday's progress"       # Review previous work
/sg:workflow "today's objectives"        # Plan daily work
/sg:implement "priority feature"         # Execute development
/sg:test --validate                      # Ensure quality
/sg:save "end-of-day-$(date +%m%d)"    # Preserve progress

# Time investment: 2-3 minutes setup, saves 20+ minutes daily
```

## Command Fundamentals

### Strategic Command Selection

**Command Categories by Purpose:**

**Discovery Commands (Project Understanding):**
```bash
# Use when: Starting new projects, onboarding, architecture review
/sg:load project/ --scope project         # Project understanding
/sg:analyze . --focus architecture        # System design analysis
/sg:brainstorm "project enhancement"       # Requirements discovery
/sg:explain "complex system behavior"     # Concept clarification

# Best practice: Always start projects with discovery commands
# Time investment: 10-15 minutes upfront saves hours later
```

**Development Commands (Active Coding):**
```bash
# Use when: Implementing features, building components, coding
/sg:implement "specific feature with clear requirements"
/sg:design "system component" --type detailed
/sg:build --optimize --target production
/sg:improve code/ --type performance --measure-impact

# Best practice: Be specific in descriptions for better agent activation
# Example: Instead of "add auth", use "implement JWT authentication with rate limiting"
```

**Quality Commands (Validation and Improvement):**
```bash
# Use when: Code review, refactoring, optimization, testing
/sg:test --coverage --validate
/sg:analyze . --focus security --think-hard
/sg:cleanup . --safe-mode
/sg:document . --scope project

# Best practice: Run quality commands before commits and deployments
# Automation: Integrate into CI/CD pipelines for consistent quality
```

**Workflow Commands (Project Management):**
```bash
# Use when: Planning, coordination, complex projects
/sg:workflow "large feature implementation"
/sg:task "project milestone" --breakdown
/sg:spawn "complex system development" --parallel
/sg:estimate "development effort" --detailed

# Best practice: Use workflow commands for >3 step processes
# Planning time: 5 minutes of planning saves 30 minutes of execution
```

### Command Optimization Strategies

**Scope Optimization for Performance:**
```bash
# Inefficient: Broad scope causing slowdowns
/sg:analyze . --scope project             # Analyzes entire project

# Optimized: Targeted scope for speed
/sg:analyze src/components/ --focus quality    # Specific directory
/sg:analyze auth.py --scope file               # Single file analysis
/sg:analyze api/ --focus security --scope module  # Focused analysis

# Performance gains: Faster execution with targeted scope
```

**Context-Aware Command Selection:**
```bash
# For new projects: Discovery-first approach
/sg:brainstorm → /sg:design → /sg:workflow → /sg:implement

# For existing projects: Analysis-first approach  
/sg:load → /sg:analyze → /sg:improve → /sg:test

# For debugging: Systematic approach
/sg:troubleshoot → /sg:analyze --focus problem-area → /sg:implement fix

# For optimization: Measure-first approach
/sg:analyze --focus performance → /sg:improve --measure-impact → /sg:test --benchmark
```

**Command Chaining for Efficiency:**
```bash
# Sequential chaining for dependent operations
/sg:design "API architecture" && /sg:implement "API endpoints" && /sg:test --api-validation

# Parallel chaining for independent operations
/sg:analyze frontend/ --focus performance & /sg:analyze backend/ --focus security & wait

# Conditional chaining for quality gates
/sg:test --coverage && /sg:analyze --focus quality && /sg:improve --safe-mode

# Time savings: Reduced total workflow time through efficient chaining
```

## Basic Flag Usage

### Essential Flag Combinations

**Development Efficiency Flags:**
```bash
# For rapid prototyping
/sg:implement "MVP feature" --scope module --validate
# --scope module: Limited scope for speed
# --validate: Verify changes before applying

# For learning and exploration
/sg:explain "complex architecture" --brainstorm
# --brainstorm: Interactive learning through dialogue

# Development speed: Faster iteration cycles through focused scope
```

**Quality-Focused Flags:**
```bash
# For production-ready development
/sg:implement "payment processing" --validate --safe-mode
# --validate: Pre-execution validation and risk assessment
# --safe-mode: Maximum safety checks and rollback capability

# For comprehensive analysis
/sg:analyze . --think --focus security
# --think: Standard structured analysis (~4K tokens)
# --focus security: Domain-specific expertise

# Quality improvements: Better validation through systematic checks
```

**Performance-Oriented Flags:**
```bash
# For large codebases (>10 files)
/sg:analyze project/ --scope module --concurrency 2
# --scope module: Limit analysis boundaries
# --concurrency 2: Basic parallel processing

# For resource-conscious development
/sg:implement "feature" --safe-mode
# --safe-mode: Conservative execution with validation

# Performance gains: Faster execution through optimized scope
```

### Flag Selection Strategy

**Context-Adaptive Flag Selection:**
```bash
# Early development phase
/sg:brainstorm "new feature" --scope project
# Focus on exploration and requirements discovery

# Implementation phase
/sg:implement "feature" --validate
# Quality gates without over-optimization

# Testing phase
/sg:test . --coverage --validate
# Comprehensive validation with safety

# Maintenance phase
/sg:improve legacy-code/ --safe-mode --validate
# Conservative improvements with comprehensive testing
```

For detailed flag documentation, see [Flags Guide](../User-Guide/flags.md).

## Session Management Basics

### Simple Session Workflows

**Basic Session Pattern:**
```bash
# Session start
/sg:load "project-name"                  # Restore previous context
/sg:reflect "current state"              # Understand where you left off

# Work session
/sg:implement "today's feature"          # Execute planned work
/sg:test --validate                      # Ensure quality

# Session end
/sg:save "progress-$(date +%m%d)"       # Save current state
```

**Daily Development Cycle:**
```bash
# Morning startup (2 minutes)
/sg:load "current-project"               # Restore context
/sg:workflow "today's priorities"        # Plan daily work

# Development work
/sg:implement "priority task"            # Execute development
/sg:test --coverage                      # Validate changes

# End of day (1 minute)
/sg:save "daily-$(date +%m%d)"         # Preserve progress
```

### Context Preservation

**Checkpoint Strategy:**
```bash
# Before major changes
/sg:save "before-refactor"               # Create restore point

# After completing features
/sg:save "feature-auth-complete"         # Mark completion

# At natural breakpoints
/sg:save "midday-checkpoint"             # Regular progress saves

# Best practice: Save every 30-60 minutes during active development
```

**Session Naming Conventions:**
```bash
# Descriptive session names
/sg:save "auth-module-complete"          # Feature completion
/sg:save "bug-fix-payment-flow"          # Bug resolution
/sg:save "sprint-3-baseline"             # Sprint milestones
/sg:save "before-major-refactor"         # Safety checkpoints

# Date-based sessions
/sg:save "daily-$(date +%Y%m%d)"        # Daily progress
/sg:save "weekly-$(date +%U)"           # Weekly milestones
```

## Daily Workflow Patterns

### Proven Development Routines

**Morning Startup Routine (5 minutes):**
```bash
# Step 1: Context restoration
/sg:load "yesterday-end"                 # Restore work context

# Step 2: Review and planning
/sg:reflect "progress and priorities"    # Understand current state
/sg:workflow "today's objectives"        # Plan daily goals

# Step 3: Ready to develop
# Context established, priorities clear, ready for productive work
```

**Feature Development Pattern:**
```bash
# Step 1: Understanding
/sg:analyze . --scope module             # Understand current code

# Step 2: Planning
/sg:design "feature specification"       # Plan implementation

# Step 3: Implementation
/sg:implement "specific feature"         # Build the feature

# Step 4: Validation
/sg:test --coverage --validate           # Ensure quality

# Step 5: Documentation
/sg:document feature/ --scope module     # Document changes
```

**End-of-Day Routine (3 minutes):**
```bash
# Step 1: Final testing
/sg:test . --quick --validate            # Ensure working state

# Step 2: Progress documentation
/sg:reflect "today's accomplishments"    # Summarize progress

# Step 3: Context preservation
/sg:save "end-$(date +%m%d)"            # Save session state

# Benefits: Clean handoff to tomorrow, no lost context
```

### Quick Problem Resolution

**Debugging Workflow:**
```bash
# Step 1: Problem identification
/sg:analyze problematic-area/ --focus issue

# Step 2: Root cause analysis
/sg:troubleshoot "specific error or behavior"

# Step 3: Solution implementation
/sg:implement "targeted fix" --validate

# Step 4: Verification
/sg:test . --focus affected-area
```

**Code Quality Issues:**
```bash
# Quick quality assessment
/sg:analyze . --focus quality --quick

# Targeted improvements
/sg:improve problematic-files/ --safe-mode

# Validation
/sg:test --coverage --validate
```

## First Week Learning Path

### Day-by-Day Progression

**Day 1: Foundation Setup**
- Install and configure SuperGemini
- Practice basic `/sg:analyze` and `/sg:implement` commands
- Learn session save/load basics
- **Goal**: Comfort with core commands

**Day 2: Project Understanding**
- Load an existing project with `/sg:load`
- Practice project analysis with `--scope` flags
- Experiment with focused analysis
- **Goal**: Project comprehension skills

**Day 3: Feature Development**
- Implement a simple feature end-to-end
- Practice test-driven development with `/sg:test`
- Learn basic error handling
- **Goal**: Complete development cycle

**Day 4: Quality Practices**
- Focus on code quality with `/sg:improve`
- Practice security analysis
- Learn documentation generation
- **Goal**: Quality-conscious development

**Day 5: Workflow Optimization**
- Practice command chaining
- Experiment with workflow planning
- Learn efficient flag combinations
- **Goal**: Workflow efficiency

**Day 6: Session Management**
- Practice long-term project workflows
- Learn checkpoint strategies
- Experiment with context preservation
- **Goal**: Project continuity skills

**Day 7: Integration and Review**
- Combine all learned concepts
- Complete a mini-project end-to-end
- Reflect on learning and optimization
- **Goal**: Integrated workflow confidence

### Skill Development Milestones

**Week 1 Success Criteria:**
- Comfortable with daily SuperGemini workflow
- Can analyze and implement features independently
- Understands basic optimization principles
- Uses session management effectively

**Week 2 Goals:**
- Master agent coordination basics
- Understand behavioral mode optimization
- Practice complex project workflows
- Develop personal workflow patterns

**Week 3 Goals:**
- Integrate advanced flags effectively
- Practice multi-agent coordination
- Optimize for specific development contexts
- Share knowledge with team members

## Common Quick Fixes

### Immediate Problem Resolution

**Scope Issues:**
```bash
# Problem: Analysis taking too long
❌ /sg:analyze massive-project/

# Quick fix: Limit scope
✅ /sg:analyze src/ --scope directory
✅ /sg:analyze problematic-file.js --scope file
```

**Command Clarity:**
```bash
# Problem: Vague requests causing confusion
❌ /sg:implement "user stuff"

# Quick fix: Be specific
✅ /sg:implement "user authentication with JWT tokens"
✅ /sg:implement "user profile editing form"
```

**Session Management:**
```bash
# Problem: Lost work context
❌ Starting new sessions without loading context

# Quick fix: Always load previous work
✅ /sg:load "last-session"
✅ /sg:reflect "current state"
```

**Quality Issues:**
```bash
# Problem: Code not meeting standards
❌ Implementing without quality checks

# Quick fix: Add validation
✅ /sg:implement "feature" --validate
✅ /sg:test --coverage after implementation
```

### Performance Quick Wins

**Faster Analysis:**
```bash
# Use targeted scope instead of project-wide analysis
/sg:analyze specific-area/ --scope module
```

**Efficient Development:**
```bash
# Combine related operations
/sg:implement "feature" && /sg:test --validate
```

**Resource Management:**
```bash
# Use safe-mode for resource-conscious development
/sg:improve . --safe-mode
```

## Quick Reference Cards

### Essential Commands Quick Reference

```bash
# Project Understanding
/sg:load project/                        # Load project context
/sg:analyze . --scope module             # Understand code structure
/sg:explain "complex concept"            # Get explanations

# Development
/sg:implement "specific feature"         # Build features
/sg:design "component spec"              # Plan implementations
/sg:improve . --focus quality            # Enhance code quality

# Quality Assurance
/sg:test --coverage                      # Run comprehensive tests
/sg:analyze . --focus security           # Security assessment
/sg:document . --scope project           # Generate documentation

# Session Management
/sg:save "session-name"                  # Save current state
/sg:load "session-name"                  # Restore previous state
/sg:reflect "current progress"           # Review and plan
```

### Essential Flags Quick Reference

```bash
# Scope Control
--scope file                             # Single file focus
--scope module                           # Module-level focus
--scope project                          # Project-wide analysis

# Quality Control
--validate                               # Pre-execution validation
--safe-mode                              # Maximum safety checks
--coverage                               # Include test coverage

# Performance (/sg: commands)
--quick                                  # Fast analysis mode (for /sg:analyze, /sg:test)
--concurrency 2                         # Basic parallel processing
```

### Daily Workflow Quick Reference

```bash
# Morning (5 min)
/sg:load "yesterday" && /sg:workflow "today's goals"

# Development (ongoing)
/sg:implement "feature" && /sg:test --validate

# Evening (3 min)
/sg:save "today-$(date +%m%d)" && /sg:reflect "progress"
```

## Next Steps

Once you've mastered these quick start practices, explore more advanced capabilities:

**Intermediate Level:**
- [Advanced Patterns](advanced-patterns.md) - Multi-agent coordination and complex workflows
- [Examples Cookbook](examples-cookbook.md) - Real-world scenario practice

**Advanced Level:**
- [Optimization Guide](optimization-guide.md) - Performance and efficiency mastery
- [MCP Servers Guide](../User-Guide/mcp-servers.md) - Enhanced tool integration

**Expert Level:**
- [Technical Architecture](../Developer-Guide/technical-architecture.md) - Deep system understanding
- [Contributing Code](../Developer-Guide/contributing-code.md) - Framework development

## Community Resources

**Learning Support:**
- [GitHub Discussions](https://github.com/SuperGemini-Org/SuperGemini_Framework/discussions) - Community help and tips
- [Troubleshooting Guide](troubleshooting.md) - Common issue resolution

**Practice Materials:**
- [Examples Cookbook](examples-cookbook.md) - Copy-paste solutions for common scenarios
- [User Guide](../User-Guide/) - Comprehensive feature documentation

---

**Your Quick Start Journey:**

Focus on building solid foundations before advancing to complex features. These practices provide immediate productivity gains while establishing patterns for long-term success.

**Success Metrics:**
- **Week 1**: Comfortable with basic workflows and daily routines
- **Week 2**: Independent feature development with quality practices
- **Week 3**: Confident session management and context preservation
- **Week 4**: Ready for advanced coordination and optimization techniques

Remember: Start simple, practice consistently, and gradually increase complexity as your confidence grows.