import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PostgresqlProviderConfig {
    /**
    * Use rds_iam instead of password authentication (see: https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/UsingWithRDS.IAMDBAuth.html)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#aws_rds_iam_auth PostgresqlProvider#aws_rds_iam_auth}
    */
    readonly awsRdsIamAuth?: boolean | cdktf.IResolvable;
    /**
    * AWS profile to use for IAM auth
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#aws_rds_iam_profile PostgresqlProvider#aws_rds_iam_profile}
    */
    readonly awsRdsIamProfile?: string;
    /**
    * Maximum wait for connection, in seconds. Zero or not specified means wait indefinitely.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#connect_timeout PostgresqlProvider#connect_timeout}
    */
    readonly connectTimeout?: number;
    /**
    * The name of the database to connect to in order to conenct to (defaults to `postgres`).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#database PostgresqlProvider#database}
    */
    readonly database?: string;
    /**
    * Database username associated to the connected user (for user name maps)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#database_username PostgresqlProvider#database_username}
    */
    readonly databaseUsername?: string;
    /**
    * Specify the expected version of PostgreSQL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#expected_version PostgresqlProvider#expected_version}
    */
    readonly expectedVersion?: string;
    /**
    * Name of PostgreSQL server address to connect to
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#host PostgresqlProvider#host}
    */
    readonly host?: string;
    /**
    * Maximum number of connections to establish to the database. Zero means unlimited.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#max_connections PostgresqlProvider#max_connections}
    */
    readonly maxConnections?: number;
    /**
    * Password to be used if the PostgreSQL server demands password authentication
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#password PostgresqlProvider#password}
    */
    readonly password?: string;
    /**
    * The PostgreSQL port number to connect to at the server host, or socket file name extension for Unix-domain connections
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#port PostgresqlProvider#port}
    */
    readonly port?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#scheme PostgresqlProvider#scheme}
    */
    readonly scheme?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#ssl_mode PostgresqlProvider#ssl_mode}
    */
    readonly sslMode?: string;
    /**
    * This option determines whether or with what priority a secure SSL TCP/IP connection will be negotiated with the PostgreSQL server
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#sslmode PostgresqlProvider#sslmode}
    */
    readonly sslmode?: string;
    /**
    * The SSL server root certificate file path. The file must contain PEM encoded data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#sslrootcert PostgresqlProvider#sslrootcert}
    */
    readonly sslrootcert?: string;
    /**
    * Specify if the user to connect as is a Postgres superuser or not.If not, some feature might be disabled (e.g.: Refreshing state password from Postgres)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#superuser PostgresqlProvider#superuser}
    */
    readonly superuser?: boolean | cdktf.IResolvable;
    /**
    * PostgreSQL user name to connect as
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#username PostgresqlProvider#username}
    */
    readonly username?: string;
    /**
    * Alias name
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#alias PostgresqlProvider#alias}
    */
    readonly alias?: string;
    /**
    * clientcert block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#clientcert PostgresqlProvider#clientcert}
    */
    readonly clientcert?: PostgresqlProviderClientcert;
}
export interface PostgresqlProviderClientcert {
    /**
    * The SSL client certificate file path. The file must contain PEM encoded data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#cert PostgresqlProvider#cert}
    */
    readonly cert: string;
    /**
    * The SSL client certificate private key file path. The file must contain PEM encoded data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql#key PostgresqlProvider#key}
    */
    readonly key: string;
}
export declare function postgresqlProviderClientcertToTerraform(struct?: PostgresqlProviderClientcert): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql postgresql}
*/
export declare class PostgresqlProvider extends cdktf.TerraformProvider {
    static readonly tfResourceType = "postgresql";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql postgresql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PostgresqlProviderConfig = {}
    */
    constructor(scope: Construct, id: string, config?: PostgresqlProviderConfig);
    private _awsRdsIamAuth?;
    get awsRdsIamAuth(): boolean | cdktf.IResolvable | undefined;
    set awsRdsIamAuth(value: boolean | cdktf.IResolvable | undefined);
    resetAwsRdsIamAuth(): void;
    get awsRdsIamAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _awsRdsIamProfile?;
    get awsRdsIamProfile(): string | undefined;
    set awsRdsIamProfile(value: string | undefined);
    resetAwsRdsIamProfile(): void;
    get awsRdsIamProfileInput(): string | undefined;
    private _connectTimeout?;
    get connectTimeout(): number | undefined;
    set connectTimeout(value: number | undefined);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): number | undefined;
    private _database?;
    get database(): string | undefined;
    set database(value: string | undefined);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _databaseUsername?;
    get databaseUsername(): string | undefined;
    set databaseUsername(value: string | undefined);
    resetDatabaseUsername(): void;
    get databaseUsernameInput(): string | undefined;
    private _expectedVersion?;
    get expectedVersion(): string | undefined;
    set expectedVersion(value: string | undefined);
    resetExpectedVersion(): void;
    get expectedVersionInput(): string | undefined;
    private _host?;
    get host(): string | undefined;
    set host(value: string | undefined);
    resetHost(): void;
    get hostInput(): string | undefined;
    private _maxConnections?;
    get maxConnections(): number | undefined;
    set maxConnections(value: number | undefined);
    resetMaxConnections(): void;
    get maxConnectionsInput(): number | undefined;
    private _password?;
    get password(): string | undefined;
    set password(value: string | undefined);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _port?;
    get port(): number | undefined;
    set port(value: number | undefined);
    resetPort(): void;
    get portInput(): number | undefined;
    private _scheme?;
    get scheme(): string | undefined;
    set scheme(value: string | undefined);
    resetScheme(): void;
    get schemeInput(): string | undefined;
    private _sslMode?;
    get sslMode(): string | undefined;
    set sslMode(value: string | undefined);
    resetSslMode(): void;
    get sslModeInput(): string | undefined;
    private _sslmode?;
    get sslmode(): string | undefined;
    set sslmode(value: string | undefined);
    resetSslmode(): void;
    get sslmodeInput(): string | undefined;
    private _sslrootcert?;
    get sslrootcert(): string | undefined;
    set sslrootcert(value: string | undefined);
    resetSslrootcert(): void;
    get sslrootcertInput(): string | undefined;
    private _superuser?;
    get superuser(): boolean | cdktf.IResolvable | undefined;
    set superuser(value: boolean | cdktf.IResolvable | undefined);
    resetSuperuser(): void;
    get superuserInput(): boolean | cdktf.IResolvable | undefined;
    private _username?;
    get username(): string | undefined;
    set username(value: string | undefined);
    resetUsername(): void;
    get usernameInput(): string | undefined;
    private _alias?;
    get alias(): string | undefined;
    set alias(value: string | undefined);
    resetAlias(): void;
    get aliasInput(): string | undefined;
    private _clientcert?;
    get clientcert(): PostgresqlProviderClientcert | undefined;
    set clientcert(value: PostgresqlProviderClientcert | undefined);
    resetClientcert(): void;
    get clientcertInput(): PostgresqlProviderClientcert | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
