# Generated by Django 2.2.28 on 2024-02-07 05:30

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('django_paypal', '0004_paypalpayment_related_resource_state'),
    ]

    operations = [
        migrations.CreateModel(
            name='PaypalAPIPostData',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(blank=True, max_length=255, verbose_name='URL')),
                ('post_data', django.contrib.postgres.fields.jsonb.JSONField(verbose_name='Post Data')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name='PaypalOrder',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('order_id', models.CharField(max_length=255, unique=True, verbose_name='Order ID')),
                ('status', models.CharField(blank=True, max_length=255, verbose_name='Status')),
            ],
        ),
        migrations.CreateModel(
            name='PaypalWebhook',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('webhook_id', models.CharField(max_length=255, unique=True, verbose_name='Webhook ID')),
                ('url', models.CharField(max_length=255, unique=True, verbose_name='URL')),
                ('event_types', django.contrib.postgres.fields.jsonb.JSONField(verbose_name='Active Webhook Events')),
            ],
        ),
        migrations.RenameModel(
            old_name='PaypalItem',
            new_name='LegacyPaypalItem',
        ),
        migrations.RenameModel(
            old_name='PaypalPayment',
            new_name='LegacyPaypalPayment',
        ),
        migrations.RenameModel(
            old_name='PaypalTransaction',
            new_name='LegacyPaypalTransaction',
        ),
        migrations.AlterModelOptions(
            name='legacypaypalitem',
            options={'verbose_name': 'Legacy Paypal Item (payments v1 API)', 'verbose_name_plural': 'Legacy Paypal Item (payments v1 API)'},
        ),
        migrations.AlterModelOptions(
            name='legacypaypalpayment',
            options={'verbose_name': 'Legacy Paypal Payment (payments v1 API)', 'verbose_name_plural': 'Legacy Paypal Payments (payments v1 API)'},
        ),
        migrations.AlterModelOptions(
            name='legacypaypaltransaction',
            options={'verbose_name': 'Legacy Paypal Transaction (payments v1 API)', 'verbose_name_plural': 'Legacy Paypal Transactions (payments v1 API)'},
        ),
        migrations.CreateModel(
            name='PaypalWebhookEvent',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('payload', django.contrib.postgres.fields.jsonb.JSONField(verbose_name='Payload')),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='webhook_events', to='django_paypal.PaypalOrder')),
                ('webhook', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='events', to='django_paypal.PaypalWebhook')),
            ],
        ),
        migrations.CreateModel(
            name='PaypalAPIResponse',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('url', models.CharField(blank=True, max_length=255, verbose_name='URL')),
                ('response_data', django.contrib.postgres.fields.jsonb.JSONField(verbose_name='Response Data')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('order', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='api_responses', to='django_paypal.PaypalOrder')),
                ('post', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='responses', to='django_paypal.PaypalAPIPostData')),
            ],
        ),
        migrations.AddField(
            model_name='paypalapipostdata',
            name='order',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='api_posts', to='django_paypal.PaypalOrder'),
        ),
    ]
