/*
 * Copyright (c) 2018 Sippy Software, Inc., http://www.sippysoft.com
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <inttypes.h>
#include <stdbool.h>

#include "config.h"

#include "rtpp_types.h"
#include "rtpp_log.h"
#include "rtpp_log_obj.h"
#include "ucl.h"
#define _RTPP_UCL_C
#include "rtpp_ucl.h"

bool
rtpp_ucl_set_unknown(struct rtpp_log *log, const ucl_object_t *top,
  const ucl_object_t *obj, void *target __attribute__((unused)))
{
    RTPP_LOG(log, RTPP_LOG_ERR, "Unknown key '%s' in section '%s'",
        ucl_object_key(obj), ucl_object_key(top));
    return (false);
}

const char *
r_ucl_object_tostring_forced(const ucl_object_t *obj)
{

    return (ucl_object_tostring_forced(obj));
}

ucl_type_t
r_ucl_object_type(const ucl_object_t *obj)
{

    return (ucl_object_type(obj));
}

int64_t
r_ucl_object_toint(const ucl_object_t *obj)
{

    return (ucl_object_toint(obj));
}

const char *
r_ucl_object_key(const ucl_object_t *obj)
{

    return (ucl_object_key(obj));
}
