# Distributed under the MIT software license, see the accompanying
# file LICENSE or http://www.opensource.org/licenses/mit-license.php.
from unittest import TestCase

from pyqryptonight.pyqryptonight import Qryptonight


class TestQryptonight(TestCase):
    def __init__(self, *args, **kwargs):
        super(TestQryptonight, self).__init__(*args, **kwargs)

    def test_init(self):
        qn = Qryptonight()

    def test_hash(self):
        qn = Qryptonight()

        input = [
            0x01, 0x05, 0x07, 0x09, 0x03, 0x05, 0x07, 0x09,
            0x01, 0x05, 0x07, 0x09, 0x03, 0x05, 0x07, 0x09,
            0x01, 0x05, 0x07, 0x09, 0x03, 0x05, 0x07, 0x09,
            0x01, 0x05, 0x07, 0x09, 0x03, 0x05, 0x07, 0x09,
            0x01, 0x05, 0x07, 0x09, 0x03, 0x05, 0x07, 0x09,
            0x01, 0x05, 0x07, 0x09, 0x03, 0x05, 0x07, 0x09,
            0x01, 0x05, 0x07, 0x09, 0x03, 0x05, 0x07, 0x09,
            0x01, 0x05, 0x07, 0x09, 0x03, 0x05, 0x07, 0x09
        ]
        output = qn.hash(input)

        output_expected = (
            0xc5, 0xbe, 0xe5, 0x37, 0x1c, 0x54, 0x7f, 0x1c,
            0x01, 0x71, 0x39, 0x38, 0x54, 0x68, 0xf9, 0xa9,
            0x8d, 0x57, 0xb2, 0x3c, 0xa6, 0xac, 0xb3, 0x80,
            0x91, 0x61, 0x8e, 0xd2, 0x81, 0x5d, 0x09, 0x46,
        )

        for i in output:
            print("0x{:02x}, ".format(i), sep='', end='')

        self.assertEqual(output_expected, output)
