"""
ryzenai_lite.utils package init.

Exports common helpers so other modules can do:
  from ryzenai_lite.utils import benchmark_inference, get_logger, device_info
"""

# Re-export commonly used utilities
from .benchmark import benchmark_inference
from .logger import get_logger, init_logger
from .memory_manager import get_memory_info, clear_cache
from .system_info import device_info, driver_info

__all__ = [
    "benchmark_inference",
    "get_logger",
    "init_logger",
    "get_memory_info",
    "clear_cache",
    "device_info",
    "driver_info",
]
