"""Simple benchmarking utilities"""
import time
import numpy as np
from typing import Dict




def benchmark_inference(model_obj, runs: int = 50):
# model_obj is an instance of api.Model
# prepare dummy input based on the backend session's first input if available
try:
backend = model_obj.backend
sess = backend.session
input_meta = sess.get_inputs()[0]
shape = input_meta.shape
dummy = np.random.rand(*[dim if isinstance(dim, int) else 1 for dim in shape]).astype(np.float32)
except Exception:
dummy = np.random.rand(1, 3, 224, 224).astype(np.float32)


# warmup
model_obj.warmup(3)


times = []
for _ in range(runs):
start = time.perf_counter()
model_obj.run({model_obj.backend.input_name