import sys
import os
sys.path.insert(0, os.path.join(os.path.dirname(__file__), '..', 'src'))

from ryzenai._lite.utils.benchmark import benchmark_inference
import numpy as np


class FakeBackend:
    def __init__(self):
        self.session = None
        self.input_name = None


class FakeModel:
    def __init__(self):
        self.backend = FakeBackend()

    def warmup(self, n=1):
        return None

    def run(self, inputs):
        # pretend to do a tiny operation
        return [np.zeros((1,))]


def test_benchmark_on_fake_model_returns_stats():
    m = FakeModel()
    stats = benchmark_inference(m, runs=5)
    assert isinstance(stats, dict)
    assert stats['runs'] == 5
    assert 'mean_s' in stats
