# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ResourceType(str, enum.Enum):
    ACCOUNT = "account"
    BRIDGE = "bridge"
    CREDENTIAL = "credential"
    INTEGRATION_POINT = "integration_point"
    INTEGRATION = "integration"
    MEMBER = "member"
    OPERATION = "operation"
    ORGANIZATION_WEBHOOK = "organization_webhook"
    ROLE = "role"
    SUB_ORG = "sub_org"
    TOKEN = "token"
    TRANSFORM = "transform"
    _UNKNOWN = "__RESOURCETYPE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ResourceType":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        account: typing.Callable[[], T_Result],
        bridge: typing.Callable[[], T_Result],
        credential: typing.Callable[[], T_Result],
        integration_point: typing.Callable[[], T_Result],
        integration: typing.Callable[[], T_Result],
        member: typing.Callable[[], T_Result],
        operation: typing.Callable[[], T_Result],
        organization_webhook: typing.Callable[[], T_Result],
        role: typing.Callable[[], T_Result],
        sub_org: typing.Callable[[], T_Result],
        token: typing.Callable[[], T_Result],
        transform: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ResourceType.ACCOUNT:
            return account()
        if self is ResourceType.BRIDGE:
            return bridge()
        if self is ResourceType.CREDENTIAL:
            return credential()
        if self is ResourceType.INTEGRATION_POINT:
            return integration_point()
        if self is ResourceType.INTEGRATION:
            return integration()
        if self is ResourceType.MEMBER:
            return member()
        if self is ResourceType.OPERATION:
            return operation()
        if self is ResourceType.ORGANIZATION_WEBHOOK:
            return organization_webhook()
        if self is ResourceType.ROLE:
            return role()
        if self is ResourceType.SUB_ORG:
            return sub_org()
        if self is ResourceType.TOKEN:
            return token()
        if self is ResourceType.TRANSFORM:
            return transform()
        return _unknown_member(self._value_)
