# This file was auto-generated by Fern from our API Definition.

from ...core.unchecked_base_model import UncheckedBaseModel
from .connection_state import ConnectionState
import pydantic
import typing
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class NetworkQuarantineRequest(UncheckedBaseModel):
    state: ConnectionState = pydantic.Field()
    """
    The connection state (Connect or Disconnect) to enforce for the provided endpoint IDs.
    """

    endpoint_ids: typing.List[str] = pydantic.Field()
    """
    The list of endpoint IDs to enforce the connection state on.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    A comment to include with the quarantine action.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
