# This file was auto-generated by Fern from our API Definition.

from ...engine.types.api_response import ApiResponse
import typing
import pydantic
from ...ticketing.types.priority import Priority
from ...organization_webhook_base.types.webhook_event import WebhookEvent
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class TicketingWebhookResponse(ApiResponse):
    ticket_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the ticket in the ticketing system.
    """

    entity_date: typing.Optional[str] = pydantic.Field(default=None)
    """
    Date pertiment to webhook operation e.g. if its TicketCreated would be creation date. This comes directly from the ticketing system without any date formatting changes.
    """

    priority: typing.Optional[Priority] = pydantic.Field(default=None)
    """
    The priority of the ticket.
    """

    short_description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Short Description of the ticket in the ticketing system.
    """

    event_type: typing.Optional[WebhookEvent] = pydantic.Field(default=None)
    """
    The type of event that was sent by the ticketing system.
    """

    raw_payload: str = pydantic.Field()
    """
    The Raw JSON that was sent by the ticketing system for this webhook event.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
