# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
import typing


class Extension(UncheckedBaseModel):
    """
    The OCSF Schema Extension object provides detailed information about the schema extension used to construct the event. The schema extensions are registered in the <a target='_blank' href='https://github.com/ocsf/ocsf-schema/blob/main/extensions.md'>extensions.md</a> file.
    """

    name: str = pydantic.Field()
    """
    The schema extension name. For example: <code>dev</code>.
    """

    uid: str = pydantic.Field()
    """
    The schema extension unique identifier. For example: <code>999</code>.
    """

    version: str = pydantic.Field()
    """
    The schema extension version. For example: <code>1.0.0-alpha.2</code>.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
