# This file was auto-generated by Fern from our API Definition.

from ......core.unchecked_base_model import UncheckedBaseModel
import typing
from .actor import Actor
import pydantic
from .sharing_permission import SharingPermission
from .sharing_scope_id import SharingScopeId
from ......core.pydantic_utilities import IS_PYDANTIC_V2


class Sharing(UncheckedBaseModel):
    """
    The Sharing object encompasses information about how and with whom a resource was shared.
    """

    actors: typing.Optional[typing.List[Actor]] = pydantic.Field(default=None)
    """
    The actor(s) with whom the resource has been shared. Note that with the addition of groups to the Actor object, sharing with a group can be represented by an Actor object with an empty user field and a populated groups field.
    """

    anonymous: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if anonymous access is enabled for sharing.
    """

    can_reshare: typing.Optional[bool] = pydantic.Field(default=None)
    """
    True if the recipients have permission to re-share the resource.
    """

    link_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique ID of a sharing link.
    """

    permissions: typing.Optional[typing.List[SharingPermission]] = pydantic.Field(
        default=None
    )
    """
    List of permissions granted.
    """

    scope: typing.Optional[str] = pydantic.Field(default=None)
    """
    The scope, normalized to the caption of the scope_id value.
    """

    scope_id: typing.Optional[SharingScopeId] = pydantic.Field(default=None)
    """
    The normalized identifier of the sharing scope.
    """

    sharing_action: typing.Optional[str] = pydantic.Field(default=None)
    """
    Describes the nature of a sharing action, such as creating a link for others to access a resource.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow"
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            smart_union = True
            extra = pydantic.Extra.allow
